/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.x12;

import com.mulesoft.flatfile.lexical.DelimiterWriter;
import com.mulesoft.flatfile.lexical.LexicalDataException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.x12.X12Constants;
import com.mulesoft.flatfile.lexical.x12.X12Utils;
import com.mulesoft.flatfile.schema.model.DelimitedElementComponent;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class X12Writer
extends DelimiterWriter {
    private char isa11Character;
    private boolean truncate;
    private ZoneOffset offset;
    private boolean lineAfterIEA;
    private Segment isaSegment = X12SchemaDefs.ISASegment();
    private Segment ieaSegment = X12SchemaDefs.IEASegment();

    public X12Writer(OutputStream os, Charset encoding, char datasep, char subsep, int repsep, char segterm, String segsep, int subst, X12Constants.CharacterRestriction chset, char isa11Character, boolean truncate, ZoneOffset offset, boolean lineAfterIEA) {
        super(os, encoding, datasep, subsep, -1, repsep, segterm, segsep, -1, -1, subst, '.', chset.flags());
        this.isa11Character = isa11Character;
        this.truncate = truncate;
        this.offset = offset;
        this.lineAfterIEA = lineAfterIEA;
    }

    public X12Writer(OutputStream os, Charset encoding, char datasep, char subsep, int repsep, char segterm, String segsep, int subst, X12Constants.CharacterRestriction chset, boolean truncate, ZoneOffset offset, boolean lineAfterIEA) {
        this(os, encoding, datasep, subsep, repsep, segterm, segsep, subst, chset, (char)(repsep > 0 ? (int)repsep : 85), truncate, offset, lineAfterIEA);
    }

    public String convertEscape(char chr) throws WriteException {
        throw new WriteException("unsupported character in data " + chr);
    }

    private void writeInterchangeControlNumber(Map<String, Object> props) throws IOException {
        try {
            X12Constants.VALN9.write(X12Writer.getRequired((String)"ISA13", props), (WriterBase)this);
        }
        catch (LexicalDataException lde) {
            throw new WriteException(lde.getMessage() + " for property '" + "ISA13" + "'");
        }
    }

    private void writeInterchangeControlNumber(Map<String, Object> props, TypeFormat format) throws IOException {
        try {
            format.write(X12Writer.getRequired((String)"ISA13", props), (WriterBase)this);
        }
        catch (LexicalDataException lde) {
            throw new WriteException(lde.getMessage() + " for property '" + "ISA13" + "'");
        }
    }

    private LocalDateTime getLocalDateTime(Object value, LocalDateTime defaultVal, String name) throws WriteException {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof Calendar) {
            Calendar calendarValue = (Calendar)value;
            TimeZone tz = calendarValue.getTimeZone();
            ZoneId zoneId = tz.toZoneId();
            return LocalDateTime.ofInstant(calendarValue.toInstant(), zoneId);
        }
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return dateValue.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (value instanceof Instant) {
            Instant instantValue = (Instant)value;
            return LocalDateTime.ofInstant(instantValue, ZoneId.systemDefault());
        }
        if (value instanceof LocalDate) {
            LocalDate localDateValue = (LocalDate)value;
            return localDateValue.atStartOfDay();
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedValue = (ZonedDateTime)value;
            return zonedValue.toLocalDateTime();
        }
        throw new WriteException("incompatible type for supplied value object: " + value.getClass().getName() + " for property '" + name + "' - expected Calendar or Date-type value");
    }

    private void writeDirect(Object value, TypeFormat vtype, String name) throws IOException {
        try {
            vtype.write(value, (WriterBase)this);
        }
        catch (LexicalDataException e) {
            throw new LexicalDataException(e, name);
        }
        this.writeDataSeparator();
    }

    public void init(Map<String, Object> props, Segment segment) throws IOException {
        this.isaSegment = segment;
        this.init(props);
    }

    private LocalDateTime getDateWithOffset(ZoneOffset offset) {
        if (offset != null) {
            OffsetDateTime offsetDate = OffsetDateTime.now(offset);
            return offsetDate.toLocalDateTime();
        }
        return LocalDateTime.now();
    }

    public void term(Map<String, Object> props, Segment segment) throws IOException {
        this.ieaSegment = segment;
        this.term(props);
    }

    public void init(Map<String, Object> props) throws IOException {
        int millis;
        this.writeToken("ISA");
        this.writeDataSeparator();
        HashMap formats = new HashMap();
        this.isaSegment.components().foreach(element -> {
            DelimitedElementComponent delement = (DelimitedElementComponent)element;
            return formats.put(delement.key(), delement.element().typeFormat());
        });
        this.writeProperty("ISA01", props, "00", (TypeFormat)formats.get("ISA01"));
        this.writeProperty("ISA02", props, "", (TypeFormat)formats.get("ISA02"));
        this.writeProperty("ISA03", props, "00", (TypeFormat)formats.get("ISA03"));
        this.writeProperty("ISA04", props, "", (TypeFormat)formats.get("ISA04"));
        this.writeProperty("ISA05", props, "00", (TypeFormat)formats.get("ISA05"));
        this.writeProperty("ISA06", props, null, (TypeFormat)formats.get("ISA06"));
        this.writeProperty("ISA07", props, "00", (TypeFormat)formats.get("ISA07"));
        this.writeProperty("ISA08", props, null, (TypeFormat)formats.get("ISA08"));
        LocalDateTime nowDateTime = this.getDateWithOffset(this.offset);
        LocalDateTime date = this.getLocalDateTime(props.get("ISA09"), nowDateTime, "ISA09");
        this.writeDirect(date.toLocalDate(), (TypeFormat)formats.get("ISA09"), "ISA09");
        Object tvalue = props.get("ISA10");
        if (tvalue == null) {
            millis = new Integer(nowDateTime.get(ChronoField.MINUTE_OF_DAY) * 60 * 1000);
        } else if (tvalue instanceof Integer) {
            millis = (Integer)tvalue;
        } else {
            throw new WriteException("incompatible type for supplied value object: " + tvalue.getClass().getName() + " for property '" + "ISA10" + "' - expected Integer value (time in milliseconds)");
        }
        this.writeDirect(millis, (TypeFormat)formats.get("ISA10"), "ISA10");
        Object version = X12Writer.getRequired((String)"ISA12", props);
        if (!(version instanceof String)) {
            throw new WriteException("incompatible type for supplied value object: " + version.getClass().getName() + " for property '" + "ISA12" + "' - expected String value");
        }
        char repetitionChar = X12Utils.validateISA11CharacterByVersion(version.toString(), this.isa11Character);
        this.writer.write(repetitionChar);
        this.writeDataSeparator();
        this.writeDirect(version, (TypeFormat)formats.get("ISA12"), "ISA12");
        this.writeInterchangeControlNumber(props, (TypeFormat)formats.get("ISA13"));
        this.writeDataSeparator();
        this.writeProperty("ISA14", props, "1", (TypeFormat)formats.get("ISA14"));
        this.writeProperty("ISA15", props, "P", (TypeFormat)formats.get("ISA15"));
        this.writeComponentSeparator();
        this.writeSegmentTerminator();
        this.groupCount = 0;
    }

    public void term(Map<String, Object> props) throws IOException {
        this.writeToken("IEA");
        this.writeDataSeparator();
        DelimitedElementComponent iea01 = (DelimitedElementComponent)this.ieaSegment.components().head();
        iea01.element().typeFormat().write((Object)this.groupCount, (WriterBase)this);
        this.writeDataSeparator();
        DelimitedElementComponent iea02 = (DelimitedElementComponent)this.ieaSegment.components().last();
        this.writeInterchangeControlNumber(props, iea02.elm().typeFormat());
        this.writeSegmentTerminator();
        if (this.lineAfterIEA && this.segmentSeparator != null) {
            this.writer.write(this.segmentSeparator);
        }
    }

    public boolean applyTruncation(TypeFormat typeFormat) {
        return this.truncate;
    }
}

