/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.operation;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.awslambda.internal.config.AwsLambdaConfiguration;
import com.mulesoft.connectors.awslambda.internal.config.CustomConfigurationOverrides;
import com.mulesoft.connectors.awslambda.internal.metadata.Get20150331FunctionsByFunctionNameOutputMetadataResolver;
import com.mulesoft.connectors.awslambda.internal.operation.CustomBaseRestOperation;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class Get20150331FunctionsByFunctionNameOperation
extends CustomBaseRestOperation {
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("\\{FunctionName}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Get Function")
    @Summary(value="Returns information about the function or function version, with a link to download the deployment package that's valid for 1...")
    @MediaType(value="application/json")
    @OutputResolver(output=Get20150331FunctionsByFunctionNameOutputMetadataResolver.class)
    public void get20150331FunctionsByFunctionName(@Config AwsLambdaConfiguration config, @Connection RestConnection connection, @DisplayName(value="Function Name") @Summary(value="The name of the Lambda function, version, or alias.") String functionName, @Optional @DisplayName(value="Qualifier") @Summary(value="Specify a version or alias to get details about a published version of the function.") String qualifier, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") CustomConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/2015-03-31/functions/{FunctionName}";
        requestPath = FUNCTION_NAME_PATTERN.matcher(requestPath).replaceAll(functionName);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("Qualifier", qualifier);
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

