/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.amazon.client;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsCredentials;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsHttpRequest;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsRoleCredentials;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsSignature;
import com.mulesoft.connectors.awslambda.internal.error.exception.AwsClientException;
import com.mulesoft.connectors.awslambda.internal.model.AssumeRoleResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsStsHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsStsHttpClient.class);
    private static final String SERVICE_NAME_STS = "sts";
    private static final String ASSUME_ROLE_RESPONSE_KEY = "AssumeRoleResponse";
    private final HttpClient httpClient;
    private final String service;
    private final AwsCredentials credentials;
    private AwsRoleCredentials roleCredentials;
    private HttpRequest assumeRoleRequestBase;
    private LocalDateTime expiration;

    public AwsStsHttpClient(HttpClient client, String service, AwsCredentials credentials, String roleArn, String customStsEndpoint) {
        this.service = service.toLowerCase();
        this.credentials = credentials;
        this.httpClient = client;
        this.expiration = LocalDateTime.MIN;
        String stsEndpoint = customStsEndpoint != null && !customStsEndpoint.isEmpty() ? customStsEndpoint : String.format("https://sts.%s.amazonaws.com/", credentials.getRegion());
        this.assumeRoleRequestBase = new RestRequestBuilder(stsEndpoint, "", HttpConstants.Method.GET).addQueryParam("Version", "2011-06-15").addQueryParam("Action", "AssumeRole").addQueryParam("RoleSessionName", UUID.randomUUID().toString()).addQueryParam("RoleArn", roleArn).addHeader("accept", "application/json").build();
    }

    public void start() {
        this.httpClient.start();
    }

    public void stop() {
        this.httpClient.stop();
    }

    public void updateCredentials() {
        if (LocalDateTime.now().plusMinutes(5L).isAfter(this.expiration)) {
            LOGGER.debug("Refreshing Role credentials...");
            AwsHttpRequest request = new AwsHttpRequest(this.assumeRoleRequestBase);
            AwsSignature signature = new AwsSignature(request, SERVICE_NAME_STS, this.credentials);
            request.sign(signature);
            try {
                HttpRequestOptions options = HttpRequestOptions.builder().build();
                HttpResponse response = this.httpClient.send((HttpRequest)request, options);
                JSONObject jsonResponse = new JSONObject(new String(response.getEntity().getBytes()));
                if (!jsonResponse.has(ASSUME_ROLE_RESPONSE_KEY)) {
                    if (jsonResponse.has("Error")) {
                        throw new AwsClientException(jsonResponse.getJSONObject("Error").getString("Message"));
                    }
                    throw new AwsClientException("Unexpected response:" + jsonResponse.toString());
                }
                AssumeRoleResponse assumeRoleResponse = new AssumeRoleResponse(jsonResponse.getJSONObject(ASSUME_ROLE_RESPONSE_KEY));
                AssumeRoleResponse.AssumeRoleResult.Credentials assumeRoleCreds = assumeRoleResponse.getResult().getCredentials();
                this.expiration = assumeRoleCreds.getExpiration();
                this.roleCredentials = new AwsRoleCredentials(assumeRoleCreds.getAccessKeyId(), assumeRoleCreds.getSecretAccessKey(), assumeRoleCreds.getSessionToken(), this.credentials.getRegion());
            }
            catch (TimeoutException e) {
                throw new AwsClientException("The STS server is not responding", e);
            }
            catch (IOException e) {
                throw new AwsClientException("Failed to get temporary credentials", e);
            }
        }
    }

    public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        this.updateCredentials();
        AwsHttpRequest awsHttpRequest = new AwsHttpRequest(request);
        AwsSignature signature = new AwsSignature(awsHttpRequest, this.service, this.roleCredentials);
        awsHttpRequest.sign(signature, this.roleCredentials.getSecurityToken());
        return this.httpClient.send((HttpRequest)awsHttpRequest, options);
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
        this.updateCredentials();
        AwsHttpRequest awsHttpRequest = new AwsHttpRequest(request);
        AwsSignature signature = new AwsSignature(awsHttpRequest, this.service, this.roleCredentials);
        awsHttpRequest.sign(signature, this.roleCredentials.getSecurityToken());
        return this.httpClient.sendAsync((HttpRequest)awsHttpRequest, options);
    }
}

