/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.amazon;

import com.mulesoft.connectors.awslambda.internal.amazon.AwsCredentials;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsHttpRequest;
import com.mulesoft.connectors.awslambda.internal.amazon.utils.HttpUtils;
import com.mulesoft.connectors.awslambda.internal.error.exception.AwsClientException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsSignature {
    private static final Logger logger = LoggerFactory.getLogger(AwsSignature.class);
    private static final String SIGNING_ALGORITHM = "HmacSHA256";
    private static final String SIGNATURE_TYPE = "AWS4-HMAC-SHA256";
    static final String HASHING_ALGORITHM = "SHA-256";
    private final AwsHttpRequest request;
    private final String service;
    private final AwsCredentials credentials;
    private final Date signingDate;
    private boolean doubleUrlEncode = false;

    public AwsSignature(AwsHttpRequest request, String service, AwsCredentials credentials) {
        this.request = request;
        this.service = service;
        this.credentials = credentials;
        this.signingDate = new Date();
    }

    public String getSignature() {
        String signingCredentials = this.credentials.getAccessKey() + "/" + this.getScope();
        String signatureInput = "AWS4-HMAC-SHA256\n" + this.getTimeStamp() + "\n" + this.getScope() + "\n" + StringUtils.toHexString((byte[])this.hash(this.canonicalRequest()));
        logger.debug("\n--------- String to sign -----------\n" + signatureInput + "\n---------------------------------------");
        String authorization = String.format("%s Credential=%s, SignedHeaders=%s, Signature=%s", SIGNATURE_TYPE, signingCredentials, this.canonicalSignedHeaderList(), StringUtils.toHexString((byte[])this.sign(signatureInput, this.getSigningKey())));
        return authorization;
    }

    protected String canonicalRequest() {
        String canonicalRequest = String.format("%s\n%s\n%s\n%s\n%s\n%s", this.request.getMethod(), this.canonicalPath(), this.canonicalQueryString(), this.canonicalHeaders(), this.canonicalSignedHeaderList(), this.request.getHash());
        logger.debug("\n--------- Canonical Request -----------\n" + canonicalRequest + "\n---------------------------------------");
        return canonicalRequest;
    }

    protected String canonicalPath() {
        String path = this.request.getUri().getPath();
        if (path == null || path.length() == 0) {
            return "/";
        }
        try {
            String value;
            path = path.replace(":", "%3A");
            String string = value = this.doubleUrlEncode ? URLEncoder.encode(path, "utf-8") : path;
            if (value.startsWith("/")) {
                return value;
            }
            return "/".concat(value);
        }
        catch (UnsupportedEncodingException e) {
            throw new AwsClientException(e.getMessage());
        }
    }

    protected String canonicalQueryString() {
        if ("POST".equals(this.request.getMethod()) && this.request.getEntity() == null) {
            return "";
        }
        return this.request.getQueryParams().entrySet().stream().sorted(Comparator.comparing(o -> (String)o.getKey() + (String)o.getValue())).map(entry -> String.format("%s=%s", HttpUtils.urlEncode((String)entry.getKey(), false), HttpUtils.urlEncode((String)entry.getValue(), false))).collect(Collectors.joining("&"));
    }

    protected Map<String, String> signedHeaders() {
        return this.request.getHeaders().toImmutableMultiMap();
    }

    protected String canonicalHeaders() {
        return this.signedHeaders().entrySet().stream().map(entry -> String.format("%s:%s\n", ((String)entry.getKey()).trim().toLowerCase(), ((String)entry.getValue()).trim().replaceAll("\\s+", " "))).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining());
    }

    protected String canonicalSignedHeaderList() {
        return this.signedHeaders().keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
    }

    protected String getScope() {
        return this.getDateStamp() + "/" + this.credentials.getRegion().toLowerCase() + "/" + this.service + "/aws4_request";
    }

    public final String getDateStamp() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.signingDate.getTime()), ZoneId.of("UTC")).toLocalDate().toString().replace("-", "");
    }

    public final String getTimeStamp() {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.signingDate.getTime()), ZoneOffset.UTC);
        return String.format("%d%02d%02dT%02d%02d%02dZ", localDateTime.getYear(), localDateTime.getMonth().getValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }

    protected byte[] getSigningKey() {
        byte[] kSecret = ("AWS4" + this.credentials.getSecretKey()).getBytes();
        byte[] kDate = this.sign(this.getDateStamp(), kSecret);
        byte[] kRegion = this.sign(this.credentials.getRegion(), kDate);
        byte[] kService = this.sign(this.service, kRegion);
        return this.sign("aws4_request", kService);
    }

    protected byte[] sign(byte[] data, byte[] key) {
        try {
            Mac mac = Mac.getInstance(SIGNING_ALGORITHM);
            mac.init(new SecretKeySpec(key, SIGNING_ALGORITHM));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new AwsClientException("Error signing data", e);
        }
    }

    private byte[] sign(String data, byte[] key) {
        return this.sign(data.getBytes(StandardCharsets.UTF_8), key);
    }

    private byte[] hash(String input) {
        return this.hash(input.getBytes(StandardCharsets.UTF_8));
    }

    private byte[] hash(byte[] input) {
        try {
            return MessageDigest.getInstance(HASHING_ALGORITHM).digest(input);
        }
        catch (Exception e) {
            throw new AwsClientException("Failed to create payload hash for AWS request", e);
        }
    }
}

