/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.queryparam.CommaQueryParamFormatter;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.queryparam.MultimapQueryParamFormatter;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.queryparam.QueryParamFormatter;
import java.io.InputStream;
import java.util.List;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRequestBuilder.class);
    private String uri;
    private HttpConstants.Method method;
    private MultiMap<String, String> headers = new CaseInsensitiveMultiMap(false);
    private MultiMap<String, String> queryParams = new MultiMap();
    private TypedValue<InputStream> body = null;
    private StreamingType streamingType = StreamingType.AUTO;
    private QueryParamFormat queryParamFormat = QueryParamFormat.MULTIMAP;

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method) {
        this(baseUri, path, method, null);
    }

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method, RequestParameters requestParameters) {
        this.uri = this.buildRequestUri(baseUri, path != null ? path : "");
        this.method = method;
        if (requestParameters != null) {
            this.headers.putAll(requestParameters.getCustomHeaders());
            this.queryParams.putAll(requestParameters.getCustomQueryParams());
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method.name();
    }

    public RestRequestBuilder addHeader(String key, String value) {
        if (value != null) {
            this.headers.put((Object)key, (Object)value);
        }
        return this;
    }

    public RestRequestBuilder addHeaders(String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            this.headers.put((Object)key, values);
        }
        return this;
    }

    public RestRequestBuilder headers(MultiMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    public RestRequestBuilder addQueryParam(String key, String value) {
        if (value != null) {
            this.queryParams.put((Object)key, (Object)value);
        }
        return this;
    }

    public RestRequestBuilder addQueryParams(String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            this.queryParams.put((Object)key, values);
        }
        return this;
    }

    public RestRequestBuilder queryParams(MultiMap<String, String> queryParams) {
        this.queryParams.putAll(queryParams);
        return this;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public RestRequestBuilder setQueryParamFormat(QueryParamFormat queryParamFormat) {
        this.queryParamFormat = queryParamFormat;
        return this;
    }

    public RestRequestBuilder setBody(TypedValue<InputStream> body, StreamingType streamingType) {
        this.body = body;
        this.streamingType = streamingType;
        return this;
    }

    private HttpEntity getStreamingConfiguredHttpEntity(TypedValue<InputStream> body, StreamingType streamingType) {
        if (body != null) {
            byte[] bytes = null;
            if (streamingType.equals((Object)StreamingType.ALWAYS)) {
                this.headers.remove((Object)"Content-Length");
                this.headers.remove((Object)"Transfer-Encoding");
                this.headers.put((Object)"Transfer-Encoding", (Object)"chunked");
            } else if (streamingType.equals((Object)StreamingType.NEVER)) {
                bytes = this.setNeverStreamingContentLength(body);
            } else {
                this.setAutoContentLengthHeader(body);
            }
            this.inferContentTypeFromBody(body);
            if (body.getValue() != null) {
                if (bytes != null) {
                    return new ByteArrayHttpEntity(bytes);
                }
                return new InputStreamHttpEntity((InputStream)body.getValue());
            }
        }
        return null;
    }

    private void inferContentTypeFromBody(TypedValue<InputStream> body) {
        MediaType mediaType;
        if (!this.headers.containsKey((Object)"Content-Type") && (mediaType = body.getDataType().getMediaType()) != null && !mediaType.getPrimaryType().equals("*")) {
            this.headers.put((Object)"Content-Type", (Object)mediaType.toRfcString());
        }
    }

    private byte[] setNeverStreamingContentLength(TypedValue<InputStream> body) {
        String customLength = (String)this.headers.get((Object)"Content-Length");
        byte[] bytes = null;
        if (customLength == null) {
            if (body.getByteLength().isPresent()) {
                this.headers.put((Object)"Content-Length", (Object)String.valueOf(body.getByteLength().getAsLong()));
            } else if (body.getValue() != null) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)body.getValue()));
                this.headers.put((Object)"Content-Length", (Object)String.valueOf(bytes.length));
            }
        }
        this.headers.remove((Object)"Transfer-Encoding");
        return bytes;
    }

    private void setAutoContentLengthHeader(TypedValue<InputStream> body) {
        String customLength = (String)this.headers.get((Object)"Content-Length");
        boolean isChunked = "chunked".equals(this.headers.get((Object)"Transfer-Encoding"));
        if (body.getByteLength().isPresent()) {
            boolean addHeader = true;
            String length = String.valueOf(body.getByteLength().getAsLong());
            if (customLength != null) {
                LOGGER.warn("Invoking URI {} with body of known length {}. However, a {} header with value {} was manually specified. Will proceed with the custom value.", new Object[]{this.uri, length, "Content-Length", customLength});
                addHeader = false;
            }
            if (isChunked) {
                LOGGER.debug("Invoking URI {} with a manually set {}: {} header, even though body is of known length {}. Skipping automatic addition of {} header", new Object[]{this.uri, "Transfer-Encoding", "chunked", length, "Content-Length"});
                addHeader = false;
            }
            if (addHeader) {
                this.headers.put((Object)"Content-Length", (Object)length);
            }
        } else if (customLength == null && !isChunked) {
            this.headers.put((Object)"Transfer-Encoding", (Object)"chunked");
        }
    }

    public HttpRequest build() {
        HttpEntity httpEntity = this.getStreamingConfiguredHttpEntity(this.body, this.streamingType);
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder((boolean)true).uri(this.uri).method(this.method).queryParams(this.queryParamFormat.getFormatter().format(this.queryParams)).headers(this.headers);
        if (httpEntity != null) {
            builder.entity(httpEntity);
        }
        return builder.build();
    }

    private String buildRequestUri(String baseUri, String path) {
        boolean pathStartsWithSlash = path.startsWith("/");
        boolean baseEndsInSlash = baseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            path = path.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            baseUri = baseUri + '/';
        }
        return baseUri + path;
    }

    public static enum QueryParamFormat {
        MULTIMAP(new MultimapQueryParamFormatter()),
        COMMA(new CommaQueryParamFormatter());

        private final QueryParamFormatter formatter;

        private QueryParamFormat(QueryParamFormatter formatter) {
            this.formatter = formatter;
        }

        public QueryParamFormatter getFormatter() {
            return this.formatter;
        }
    }
}

