/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.valueprovider;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.builder.dataexpressions.SequenceCompositeDataExpressionBuilder;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.common.Evaluable;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions.HttpRequestDataExpression;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions.SequenceCompositeDataExpression;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.resolvers.ResolverDefinition;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.DwUtils;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestSdkUtils;

public class ValueProviderResolverDefinition
extends ResolverDefinition
implements Evaluable {
    public static final String ID_PROPERTY_KEY = "id";
    public static final String DISPLAY_NAME_PROPERTY_KEY = "name";
    private static final String EXTRACTION_EXPRESSION_PLACEHOLDER = "%{extraction-expression}";
    private static final String ID_EXPRESSION_PLACEHOLDER = "%{id-expression}";
    private static final String DISPLAY_NAME_EXPRESSION_PLACEHOLDER = "%{name-expression}";
    private static final String MAP_EXPRESSION_TEMPLATE = "(%{extraction-expression}) map (item, index) -> {    id: (%{id-expression}) as String,    name: (%{name-expression}) as String }";
    private final SequenceCompositeDataExpression sequence;

    public ValueProviderResolverDefinition(HttpRequestDataExpression httpRequestDataExpression, String itemExtractionExpression, String itemNameExpression, String itemValueExpression) {
        this.sequence = this.buildSequence(httpRequestDataExpression, itemExtractionExpression, itemNameExpression, itemValueExpression);
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        return this.sequence.evaluate(evaluationContext);
    }

    private SequenceCompositeDataExpression buildSequence(HttpRequestDataExpression httpRequestDataExpression, String itemExtractionExpression, String itemNameExpression, String itemValueExpression) {
        String mapExpression = this.buildMapExpression(itemExtractionExpression, itemNameExpression, itemValueExpression);
        return new SequenceCompositeDataExpressionBuilder().step(step -> step.withDataExpression(httpRequestDataExpression)).step(step -> step.dataExpression(exp -> exp.script(script -> script.scriptExpression(dw -> dw.expression(mapExpression))))).build();
    }

    private String buildMapExpression(String itemExtractionExpression, String itemNameExpression, String itemValueExpression) {
        return MAP_EXPRESSION_TEMPLATE.replace(EXTRACTION_EXPRESSION_PLACEHOLDER, DwUtils.getCleanExpression(itemExtractionExpression)).replace(ID_EXPRESSION_PLACEHOLDER, DwUtils.getCleanExpression(itemValueExpression)).replace(DISPLAY_NAME_EXPRESSION_PLACEHOLDER, this.getItemNameExpression(itemNameExpression, itemValueExpression));
    }

    private String getItemNameExpression(String itemNameExpression, String itemValueExpression) {
        String cleanNameExpression = DwUtils.getCleanExpression(itemNameExpression);
        if (RestSdkUtils.isNotBlank(cleanNameExpression)) {
            return cleanNameExpression;
        }
        return DwUtils.getCleanExpression(itemValueExpression);
    }
}

