/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.builder.resolvers;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.builder.common.ArgumentBuilder;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.builder.resolvers.ResolverArgumentBuilder;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.resolvers.ResolverArgument;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.resolvers.ResolverReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ResolverReferenceBuilder {
    private String declaration;
    private final List<ResolverArgumentBuilder> arguments = new ArrayList<ResolverArgumentBuilder>();

    public ResolverReferenceBuilder declaration(String declaration) {
        this.declaration = declaration;
        return this;
    }

    public ResolverReferenceBuilder argument(String name, Consumer<ResolverArgumentBuilder> consumer) {
        ResolverArgumentBuilder argument = new ResolverArgumentBuilder(name);
        consumer.accept(argument);
        this.arguments.add(argument);
        return this;
    }

    private String buildDeclaration() {
        if (this.declaration == null) {
            throw new IllegalStateException("No declaration name set");
        }
        return this.declaration;
    }

    private List<ResolverArgument> buildArguments() {
        return this.arguments.stream().map(ArgumentBuilder::build).collect(Collectors.toList());
    }

    public ResolverReference build() {
        return new ResolverReference(this.buildDeclaration(), this.buildArguments());
    }
}

