/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.validation;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.validation.ConnectionValidationSettings;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.validation.TestConnectionValidation;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.ConnectionValidationUtils;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestSdkUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionValidator.class);

    public static ConnectionValidationResult validateConnectionResponse(HttpResponse response, ConnectionValidationSettings settings) {
        return ConnectionValidator.validateConnectionResponse(response, settings.getValidStatusCodes(), settings.getExpressionLanguage(), settings.getTestConnectionValidations(), settings.getResponseMediaType());
    }

    private static ConnectionValidationResult validateConnectionResponse(HttpResponse response, Set<Integer> validStatusCodes, ExpressionLanguage expressionLanguage, List<TestConnectionValidation> testConnectionValidations, MediaType responseMediaType) {
        if (validStatusCodes.stream().noneMatch(x -> x.equals(response.getStatusCode()))) {
            StringJoiner statusCodeJoiner = new StringJoiner(", ");
            validStatusCodes.forEach(x -> statusCodeJoiner.add(x.toString()));
            return ConnectionValidationUtils.connectionExceptionResult(String.format("Server responded with status code %s. Expected status code were: [%s]", response.getStatusCode(), statusCodeJoiner.toString()));
        }
        BindingContext context = ConnectionValidator.buildValidationResponseContext(response, responseMediaType);
        for (TestConnectionValidation expression : testConnectionValidations) {
            ConnectionValidationResult validationResult = ConnectionValidator.validateExpression(context, expressionLanguage, expression);
            if (validationResult.isValid()) continue;
            return validationResult;
        }
        return ConnectionValidationResult.success();
    }

    private static ConnectionValidationResult validateExpression(BindingContext bindingContext, ExpressionLanguage expressionLanguage, TestConnectionValidation testConnectionValidation) {
        String validationExp = testConnectionValidation.getValidationExpression();
        if (RestSdkUtils.isNotBlank(validationExp)) {
            ValidationResult validationResult = expressionLanguage.validate(validationExp);
            if (!validationResult.isSuccess()) {
                return ConnectionValidationUtils.connectionExceptionResult(String.format("Validation expression is not valid. %s", validationExp));
            }
            try {
                TypedValue expressionResult = expressionLanguage.evaluate(validationExp, DataType.BOOLEAN, bindingContext);
                if (!expressionResult.getValue().equals(true)) {
                    String errorMessage = ConnectionValidator.tryGetErrorMessage(bindingContext, expressionLanguage, testConnectionValidation);
                    return RestSdkUtils.isBlank(errorMessage) ? ConnectionValidationUtils.connectionExceptionResult(String.format("Expression evaluation did not return true. Expression: %s", validationExp)) : ConnectionValidationUtils.connectionExceptionResult(errorMessage);
                }
            }
            catch (ExpressionRuntimeException e) {
                return ConnectionValidationUtils.connectionExceptionResult(String.format("Runtime error evaluating expression: %s", validationExp), e);
            }
        }
        return ConnectionValidationResult.success();
    }

    private static String tryGetErrorMessage(BindingContext bindingContext, ExpressionLanguage expressionLanguage, TestConnectionValidation testConnectionValidation) {
        String errorExp = testConnectionValidation.getErrorTemplateExpression();
        if (RestSdkUtils.isNotBlank(errorExp)) {
            try {
                TypedValue expressionResult = expressionLanguage.evaluate(errorExp, DataType.STRING, bindingContext);
                return expressionResult.getValue().toString();
            }
            catch (Throwable t) {
                LOGGER.error("Error evaluating error template expression", t);
            }
        }
        return null;
    }

    private static BindingContext buildValidationResponseContext(HttpResponse response, MediaType overrideMediaType) {
        MediaType defaultMediaType = response.containsHeader("Content-Type") ? MediaType.parse((String)response.getHeaderValue("Content-Type")) : MediaType.APPLICATION_JSON;
        MediaType mediaType = overrideMediaType != null ? overrideMediaType : defaultMediaType;
        Charset charset = mediaType.getCharset().orElse(Charset.defaultCharset());
        return BindingContext.builder().addBinding("payload", RestSdkUtils.consumeStringAndClose(response.getEntity().getContent(), mediaType, charset)).addBinding("attributes", TypedValue.of((Object)ConnectionValidator.toAttributes(response))).build();
    }

    private static HttpResponseAttributes toAttributes(HttpResponse response) {
        return new HttpResponseAttributes(response.getStatusCode(), response.getReasonPhrase(), (MultiMap<String, String>)response.getHeaders());
    }
}

