/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.util;

import com.mulesoft.connectors.ws.internal.util.WebSocketDecorator;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;

public class SynchronizedWebSocketDecorator
extends WebSocketDecorator {
    protected final Lock socketLock = new ReentrantLock();

    public SynchronizedWebSocketDecorator(WebSocket delegate) {
        super(delegate);
    }

    @Override
    public CompletableFuture<Void> close(WebSocketCloseCode code, String reason) {
        return (CompletableFuture)this.synchronizedOperation(() -> super.close(code, reason));
    }

    @Override
    public CompletableFuture<Void> send(InputStream content, MediaType mediaType) {
        return (CompletableFuture)this.synchronizedOperation(() -> super.send(content, mediaType));
    }

    @Override
    public CompletableFuture<Void> sendFrame(byte[] frameBytes) {
        return (CompletableFuture)this.synchronizedOperation(() -> super.sendFrame(frameBytes));
    }

    protected <T> T synchronizedOperation(CheckedSupplier<T> action) {
        this.socketLock.lock();
        try {
            Object object = action.get();
            return (T)object;
        }
        finally {
            this.socketLock.unlock();
        }
    }
}

