/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.operation;

import com.mulesoft.connectors.ws.api.BroadcastFailure;
import com.mulesoft.connectors.ws.api.BroadcastSocketType;
import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import com.mulesoft.connectors.ws.api.client.WebSocketClientSettings;
import com.mulesoft.connectors.ws.api.client.WebSocketRequestBuilder;
import com.mulesoft.connectors.ws.api.exception.NoSuchSocketException;
import com.mulesoft.connectors.ws.internal.WebSocketsConnector;
import com.mulesoft.connectors.ws.internal.client.WebSocketClient;
import com.mulesoft.connectors.ws.internal.connection.FluxCapacitor;
import com.mulesoft.connectors.ws.internal.error.BroadcastErrorProvider;
import com.mulesoft.connectors.ws.internal.error.DefaultErrorProvider;
import com.mulesoft.connectors.ws.internal.error.GroupSubscriptionErrorProvider;
import com.mulesoft.connectors.ws.internal.error.OpenOutboundSocketErrorTypeProvider;
import com.mulesoft.connectors.ws.internal.error.WsError;
import com.mulesoft.connectors.ws.internal.operation.UriSettings;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.exception.InvalidStatusCodeException;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;

public class WebSocketOperations {
    private static final WebSocketRequestBuilder DEFAULT_REQUEST_BUILDER = new WebSocketRequestBuilder();
    @Inject
    private MuleContext muleContext;

    @Throws(value={DefaultErrorProvider.class})
    public void send(String socketId, @Content TypedValue<InputStream> content, @Connection FluxCapacitor fluxCapacitor, CompletionCallback<Void, Void> callback, RetryPolicyTemplate retryPolicyTemplate) {
        this.doSend(socketId, content, fluxCapacitor, callback, retryPolicyTemplate, retryPolicyTemplate.isEnabled());
    }

    private void doSend(String socketId, TypedValue<InputStream> content, FluxCapacitor fluxCapacitor, CompletionCallback<Void, Void> callback, RetryPolicyTemplate retryPolicyTemplate, boolean reconnect) {
        try {
            InputStream stream = (InputStream)content.getValue();
            WebSocketUtils.ifRepeatable(stream, (CheckedConsumer<CursorStream>)((CheckedConsumer)cursor -> cursor.mark(Integer.MAX_VALUE)));
            fluxCapacitor.send(socketId, stream, content.getDataType().getMediaType()).whenComplete((v, e) -> {
                if (e != null) {
                    if (reconnect && e instanceof WebSocketConnectionException) {
                        fluxCapacitor.reconnectOnFailure(socketId, (WebSocketConnectionException)e, retryPolicyTemplate).whenComplete((r, re) -> {
                            if (re != null) {
                                callback.error((Throwable)this.mapException((Throwable)e));
                            } else {
                                WebSocketUtils.ifRepeatable(stream, (CheckedConsumer<CursorStream>)((CheckedConsumer)InputStream::reset));
                                this.doSend(socketId, content, fluxCapacitor, callback, retryPolicyTemplate, false);
                            }
                        });
                    } else {
                        callback.error((Throwable)this.mapException((Throwable)e));
                    }
                } else {
                    callback.success(Result.builder().build());
                }
            });
        }
        catch (Exception e2) {
            callback.error((Throwable)e2);
        }
    }

    @Throws(value={BroadcastErrorProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    public void broadcast(@Content TypedValue<InputStream> content, @Connection FluxCapacitor fluxCapacitor, String path, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="ALL") BroadcastSocketType socketType, @org.mule.runtime.extension.api.annotation.param.Optional @NullSafe List<String> groups, RetryPolicyTemplate retryPolicyTemplate, CompletionCallback<List<BroadcastFailure>, Void> completionCallback) {
        Predicate<WebSocket> filter = this.newSocketFilter(socketType, groups);
        LinkedList failures = new LinkedList();
        fluxCapacitor.broadcast(content, path, filter, retryPolicyTemplate, (ws, e) -> {
            List list = failures;
            synchronized (list) {
                failures.add(new BroadcastFailure((WebSocket)ws, (Throwable)e));
            }
        }).whenComplete((v, e) -> {
            if (e != null) {
                completionCallback.error(e);
            } else {
                completionCallback.success(Result.builder().output((Object)failures).build());
            }
        });
    }

    @Throws(value={BroadcastErrorProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    public void bulkCloseSockets(@Connection FluxCapacitor fluxCapacitor, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="ALL") BroadcastSocketType socketType, @org.mule.runtime.extension.api.annotation.param.Optional @NullSafe List<String> groups, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="NORMAL_CLOSURE") WebSocketCloseCode closeCode, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="") String reason, CompletionCallback<Void, Void> completionCallback) {
        fluxCapacitor.bulkCloseSockets(this.newSocketFilter(socketType, groups), closeCode, reason).whenComplete((v, e) -> {
            if (e != null) {
                completionCallback.error(e);
            } else {
                completionCallback.success(Result.builder().output(null).build());
            }
        });
    }

    private Predicate<WebSocket> newSocketFilter(BroadcastSocketType socketType, List<String> groups) {
        Predicate<WebSocket> filter = socketType.asFilter();
        if (!groups.isEmpty()) {
            filter = filter.and(ws -> ws.getGroups().stream().anyMatch(groups::contains));
        }
        return filter;
    }

    @MediaType(value="text/plain")
    @Throws(value={OpenOutboundSocketErrorTypeProvider.class})
    public void openOutboundSocket(@org.mule.runtime.extension.api.annotation.param.Optional String socketId, @Placement(order=1) @ParameterGroup(name="URI Settings") UriSettings uriSettings, @Placement(order=2) @ParameterGroup(name="Connection Request") WebSocketRequestBuilder connectionRequestBuilder, @org.mule.runtime.extension.api.annotation.param.Optional @NullSafe List<String> defaultGroups, @Config WebSocketsConnector config, @Connection FluxCapacitor fluxCapacitor, CompletionCallback<String, WebSocketAttributes> callback) {
        try {
            String resolvedUri;
            WebSocketClient webSocketClient = fluxCapacitor.unsafeGetWebSocketClient(config);
            HttpClient client = webSocketClient.getHttpClient();
            WebSocketRequestBuilder resolvedBuilder = connectionRequestBuilder != null ? connectionRequestBuilder : DEFAULT_REQUEST_BUILDER;
            WebSocketClientSettings clientSettings = webSocketClient.getSettings();
            if (uriSettings.getUrl() == null) {
                String resolvedBasePath = clientSettings.getBasePath();
                String resolvedPath = resolvedBuilder.replaceUriParams(WebSocketUtils.resolveFullPath(resolvedBasePath, uriSettings.getPath()));
                resolvedUri = this.resolveUri(clientSettings.getProtocol(), clientSettings.getHost(), clientSettings.getPort(), resolvedPath);
            } else {
                resolvedUri = resolvedBuilder.replaceUriParams(uriSettings.getUrl());
            }
            HttpRequest request = this.buildHttpRequest(resolvedUri, clientSettings, connectionRequestBuilder);
            fluxCapacitor.openOutboundSocket(config, client, request, defaultGroups, Optional.ofNullable(socketId), clientSettings.getConnectionIdleTimeoutMillis()).whenComplete((a, e) -> {
                if (e != null) {
                    callback.error((Throwable)this.mapException((Throwable)e));
                } else {
                    callback.success(Result.builder().output((Object)"").attributes(a).build());
                }
            });
        }
        catch (Throwable t) {
            callback.error((Throwable)this.mapException(t));
        }
    }

    @Throws(value={DefaultErrorProvider.class})
    public void closeSocket(String socketId, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="NORMAL_CLOSURE") WebSocketCloseCode closeCode, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="") String reason, @Connection FluxCapacitor fluxCapacitor, CompletionCallback<Void, Void> callback) {
        try {
            fluxCapacitor.close(socketId, closeCode, reason).whenComplete((a, e) -> {
                if (e != null) {
                    callback.error((Throwable)this.mapException((Throwable)e));
                } else {
                    callback.success(Result.builder().build());
                }
            });
        }
        catch (Exception e2) {
            callback.error((Throwable)this.mapException(e2));
        }
    }

    @Throws(value={GroupSubscriptionErrorProvider.class})
    public void subscribeGroups(@Connection FluxCapacitor fluxCapacitor, String socketId, List<String> groups) throws Exception {
        try {
            fluxCapacitor.subscribeGroups(fluxCapacitor.lookupWebSocket(socketId), groups);
        }
        catch (Exception e) {
            throw this.mapException(e);
        }
    }

    @Throws(value={GroupSubscriptionErrorProvider.class})
    public void unsubscribeGroups(@Connection FluxCapacitor fluxCapacitor, String socketId, List<String> groups) throws Exception {
        try {
            fluxCapacitor.unsubscribeGroups(fluxCapacitor.lookupWebSocket(socketId), groups);
        }
        catch (Exception e) {
            throw this.mapException(e);
        }
    }

    private Exception mapException(Throwable t) {
        if (t instanceof CompletionException) {
            t = t.getCause();
        }
        if (t instanceof ModuleException) {
            return (ModuleException)t;
        }
        WsError errorType = WsError.CONNECTIVITY;
        if (t instanceof InvalidStatusCodeException) {
            WsError error = WsError.getErrorByCode(((InvalidStatusCodeException)t).getStatus()).orElse(null);
            if (error != null) {
                errorType = error;
            }
        } else if (t instanceof NoSuchSocketException) {
            errorType = WsError.NO_SUCH_SOCKET;
        } else if ("Remotely closed".equalsIgnoreCase(t.getMessage())) {
            errorType = WsError.REMOTELY_CLOSED;
        }
        return new ModuleException(t.getMessage(), (ErrorTypeDefinition)errorType, t);
    }

    private HttpRequest buildHttpRequest(String uri, WebSocketClientSettings clientSettings, WebSocketRequestBuilder requestBuilder) {
        HttpRequestBuilder builder = requestBuilder.toRequestBuilder(clientSettings).uri(uri);
        clientSettings.getDefaultHeaders().forEach(header -> {
            HttpRequestBuilder cfr_ignored_0 = (HttpRequestBuilder)builder.addHeader(header.getKey(), header.getValue());
        });
        clientSettings.getDefaultQueryParams().forEach(param -> builder.addQueryParam(param.getKey(), param.getValue()));
        if (clientSettings.getAuthentication() != null) {
            try {
                clientSettings.getAuthentication().authenticate(builder);
            }
            catch (MuleException e) {
                throw new ModuleException((ErrorTypeDefinition)MuleErrors.SECURITY, (Throwable)e);
            }
        }
        return builder.build();
    }

    private String resolveUri(WebSocketProtocol protocol, String host, Integer port, String path) {
        return protocol.getScheme() + "://" + host + ":" + port + HttpEncoderDecoderUtils.encodeSpaces((String)path);
    }
}

