/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.connection;

import com.mulesoft.connectors.ws.api.client.WebSocketClientSettings;
import com.mulesoft.connectors.ws.api.server.WebSocketServerSettings;
import com.mulesoft.connectors.ws.internal.client.WebSocketClient;
import com.mulesoft.connectors.ws.internal.connection.FluxCapacitor;
import com.mulesoft.connectors.ws.internal.server.WebSocketServer;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxCapacitorProvider
implements CachedConnectionProvider<FluxCapacitor>,
Initialisable,
Startable,
Stoppable {
    private static final int UNLIMITED_CONNECTIONS = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(FluxCapacitorProvider.class);
    @Inject
    private SchedulerService schedulerService;
    @Parameter
    @Optional
    @NullSafe
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private WebSocketServerSettings serverSettings;
    @Parameter
    @Optional
    @NullSafe
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private WebSocketClientSettings clientSettings;
    @Inject
    private HttpService httpService;
    @Inject
    private MuleContext muleContext;
    @RefName
    private String configName;
    private Scheduler reconnectionScheduler;
    private AtomicLong clientCounter = new AtomicLong(0L);
    private TlsContextFactoryBuilder defaultTlsContextFactoryBuilder = TlsContextFactory.builder();

    public void initialise() throws InitialisationException {
        this.initialiseClient();
    }

    public void start() throws MuleException {
        this.reconnectionScheduler = this.schedulerService.ioScheduler(SchedulerConfig.config().withName(this.configName + "-reconnection-scheduler"));
    }

    public void stop() throws MuleException {
        if (this.reconnectionScheduler != null) {
            this.reconnectionScheduler.stop();
        }
    }

    private void initialiseClient() throws InitialisationException {
        WebSocketProtocol protocol = this.clientSettings.getProtocol();
        TlsContextFactory tlsContext = this.clientSettings.getTlsContext();
        if (protocol == WebSocketProtocol.WS && tlsContext != null && LOGGER.isWarnEnabled()) {
            LOGGER.warn("<tls:context> was configured but protocol was set to 'WS'. Change protocol to 'WSS' for TLS to take effect");
        }
        if (protocol == WebSocketProtocol.WSS && tlsContext == null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.defaultTlsContextFactoryBuilder);
            tlsContext = this.defaultTlsContextFactoryBuilder.buildDefault();
            this.clientSettings.setTlsContext(tlsContext);
        }
        if (tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)tlsContext);
        }
        if (this.clientSettings.getAuthentication() != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.clientSettings.getAuthentication(), (boolean)true, (MuleContext)this.muleContext);
        }
        this.verifyClientParameters();
    }

    private void verifyClientParameters() throws InitialisationException {
        if (this.clientSettings.getMaxConnections() < -1 || this.clientSettings.getMaxConnections() == 0) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
    }

    public FluxCapacitor connect() throws ConnectionException {
        return new FluxCapacitor(this.createWebSocketServer(), this.createWebSocketClient(), this.httpService, this.reconnectionScheduler);
    }

    public void disconnect(FluxCapacitor fluxCapacitor) {
        fluxCapacitor.close();
    }

    public ConnectionValidationResult validate(FluxCapacitor connection) {
        HttpServer httpServer = connection.getWebSocketServer().map(s -> s.getHttpServer()).orElse(null);
        if (httpServer != null && (httpServer.isStopped() || httpServer.isStopping())) {
            ServerAddress serverAddress = httpServer.getServerAddress();
            return ConnectionValidationResult.failure((String)String.format("Server on host %s and port %s is stopped.", serverAddress.getIp(), serverAddress.getPort()), (Exception)new ConnectionException("Server stopped."));
        }
        return ConnectionValidationResult.success();
    }

    private WebSocketServer createWebSocketServer() {
        if (this.serverSettings != null) {
            return new WebSocketServer(this.lookupHttpServer(), this.serverSettings);
        }
        return null;
    }

    private HttpServer lookupHttpServer() {
        String listenerConfigName = this.serverSettings.getListenerConfig();
        HttpServer httpServer = null;
        if (listenerConfigName != null) {
            try {
                httpServer = this.httpService.getServerFactory().lookup(listenerConfigName);
            }
            catch (ServerNotFoundException e) {
                throw new IllegalArgumentException(String.format("WebSocket configuration '%s' refers to an <http:listener-config> with name '%s', but such element doesn't exists", this.configName, listenerConfigName), e);
            }
        }
        return httpServer;
    }

    private WebSocketClient createWebSocketClient() throws ConnectionException {
        if (this.clientSettings != null) {
            return new WebSocketClient(this.createHttpClient(), this.clientSettings);
        }
        return null;
    }

    private HttpClient createHttpClient() throws ConnectionException {
        int connectionIdleTimeout = this.clientSettings.getConnectionIdleTimeoutMillis();
        HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.clientSettings.getTlsContext()).setProxyConfig((ProxyConfig)this.clientSettings.getProxyConfig()).setMaxConnections(this.clientSettings.getMaxConnections().intValue()).setUsePersistentConnections(true).setConnectionIdleTimeout(connectionIdleTimeout).setClientSocketProperties(TcpClientSocketProperties.builder().keepAlive(Boolean.valueOf(true)).clientTimeout(Integer.valueOf(connectionIdleTimeout)).build()).setName("ws.client." + this.configName + "." + this.clientCounter.incrementAndGet()).build();
        HttpClient httpClient = this.httpService.getClientFactory().create(configuration);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new ConnectionException((Throwable)e);
        }
        return httpClient;
    }
}

