/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.resolvers;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverArgument;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverDeclaration;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ResolverReference
implements ResolverExpression {
    private static final String KEY_PARAMETER = "parameter";
    private final String declarationName;
    private final Map<String, ResolverArgument> argumentsByName;

    public ResolverReference(String declarationName, List<ResolverArgument> arguments) {
        this.declarationName = declarationName;
        this.argumentsByName = new HashMap<String, ResolverArgument>();
        arguments.forEach(resolverArgument -> this.argumentsByName.put(resolverArgument.getName(), (ResolverArgument)resolverArgument));
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        SimpleEvaluationContext functionEvaluationContext = new SimpleEvaluationContext(evaluationContext.getGlobalEvaluationContext().orElse(null));
        ResolverDeclaration declaration = evaluationContext.resolveDeclaration(this.declarationName);
        HashMap parametersMap = new HashMap();
        declaration.getParameters().forEach(resolverParameter -> {
            ResolverArgument resolverArgument = Optional.ofNullable(this.argumentsByName.get(resolverParameter.getName())).orElseThrow(() -> new RuntimeException(String.format("No argument provided for parameter %s", resolverParameter.getName())));
            parametersMap.put(resolverParameter.getName(), resolverArgument.getValue().evaluate(evaluationContext));
        });
        functionEvaluationContext.define(KEY_PARAMETER, parametersMap);
        return declaration.evaluate(functionEvaluationContext);
    }
}

