/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.ArrayHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.BooleanHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.CombinedHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.EmptyHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.EnumHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.NullHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.NumberHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.ObjectHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.ReferenceHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.SchemaHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.StringHandler;
import java.util.Arrays;
import java.util.List;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;

public class RestHandlerManager {
    private MetadataFormat metadataFormat;
    private List<? extends SchemaHandler> handlers = Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(), new EnumHandler(), new NullHandler(), new NumberHandler(), new ObjectHandler(), new ReferenceHandler(), new StringHandler());

    public RestHandlerManager(MetadataFormat metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
        if (parsingContext.isAlreadyBuild(schema)) {
            return parsingContext.getBuilder(schema).orElse(null);
        }
        for (SchemaHandler schemaHandler : this.handlers) {
            if (!schemaHandler.handles(schema)) continue;
            return schemaHandler.handle(schema, BaseTypeBuilder.create((MetadataFormat)this.metadataFormat), this, parsingContext);
        }
        return BaseTypeBuilder.create((MetadataFormat)this.metadataFormat).anyType();
    }
}

