/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Stream;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

public class HttpResponseAttributes
implements Serializable {
    private static final String TAB = "   ";
    private static final String DOUBLE_TAB = "      ";
    private static final long serialVersionUID = -3131769059554988414L;
    @Parameter
    private final int statusCode;
    @Parameter
    private MultiMap<String, String> headers;
    @Parameter
    private final String reasonPhrase;

    public HttpResponseAttributes(int statusCode, String reasonPhrase, MultiMap<String, String> headers) {
        this.headers = headers != null ? new CaseInsensitiveMultiMap(headers) : MultiMap.emptyMultiMap();
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(System.lineSeparator()).append("{").append(System.lineSeparator()).append(TAB).append("Status Code=").append(this.statusCode).append(System.lineSeparator()).append(TAB).append("Reason Phrase=").append(this.reasonPhrase).append(System.lineSeparator());
        this.buildMapToString((Map<?, ?>)this.headers, "Headers", this.headers.entryList().stream(), builder);
        builder.append("}");
        return builder.toString();
    }

    private String formatHttpAttributesMapsToString(String name, Stream<Map.Entry<String, String>> stream) {
        StringBuilder builder = new StringBuilder();
        builder.append(TAB).append(name).append("=[").append(System.lineSeparator());
        stream.forEach(element -> builder.append(DOUBLE_TAB).append((String)element.getKey()).append("=").append(this.obfuscateValueIfNecessary((Map.Entry<String, String>)element)).append(System.lineSeparator()));
        builder.append(TAB).append("]").append(System.lineSeparator());
        return builder.toString();
    }

    private String obfuscateValueIfNecessary(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        if (key.equals("password") || key.equals("pass") || key.contains("secret") || key.contains("authorization")) {
            return "****";
        }
        return entry.getValue();
    }

    private StringBuilder buildMapToString(Map<?, ?> map, String name, Stream<Map.Entry<String, String>> stream, StringBuilder builder) {
        if (map.isEmpty()) {
            builder.append(TAB).append(name).append("=[]").append(System.lineSeparator());
            return builder;
        }
        builder.append(this.formatHttpAttributesMapsToString(name, stream));
        return builder;
    }
}

