/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.EvaluationContextBuilderFactory;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider.ValueProviderResolverExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverExpression;
import com.mulesoft.connectivity.rest.commons.internal.util.ResolverUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public abstract class RestValueProvider
implements ValueProvider {
    @Config
    private RestConfiguration config;
    @Connection
    protected RestConnection connection;
    @Inject
    private ExpressionLanguage expressionLanguage;

    protected abstract void build(ValueProviderResolverExpressionBuilder var1);

    protected Optional<EvaluationContext> getGlobalEvaluationContext() {
        return Optional.empty();
    }

    protected EvaluationContext buildEvaluationContext(EvaluationContextBuilderFactory evaluationContextBuilderFactory) {
        return evaluationContextBuilderFactory.emptyContextBuilder().build();
    }

    public Set<Value> resolve() throws ValueResolvingException {
        ValueProviderResolverExpressionBuilder builder = new ValueProviderResolverExpressionBuilder();
        this.build(builder);
        ResolverExpression valueProviderResolverExpression = builder.build();
        Object resultOutput = valueProviderResolverExpression.evaluate(this.createEvaluationContext());
        return this.getValuesFromResult(resultOutput);
    }

    private EvaluationContext createEvaluationContext() {
        EvaluationContext parentEvaluationContext = ResolverUtil.createParentEvaluationContext(this.getGlobalEvaluationContext().orElse(null), this.config, this.connection, this.expressionLanguage);
        EvaluationContextBuilderFactory evaluationContextBuilderFactory = new EvaluationContextBuilderFactory(parentEvaluationContext);
        return this.buildEvaluationContext(evaluationContextBuilderFactory);
    }

    private Set<Value> getValuesFromResult(Object resultOutput) {
        HashSet<Value> values = new HashSet<Value>();
        for (Object o : this.getJsonArray(resultOutput)) {
            values.add(this.getValueFromJsonObject((JSONObject)o));
        }
        return values;
    }

    private Value getValueFromJsonObject(JSONObject jsonObject) {
        return ValueBuilder.newValue((String)jsonObject.getString("id")).withDisplayName(jsonObject.getString("name")).build();
    }

    private JSONArray getJsonArray(Object resultOutput) {
        String s = ((TypedValue)resultOutput).getValue().toString();
        return new JSONArray(s);
    }
}

