/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.oauth;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class OAuthRestConnection
extends DefaultRestConnection {
    private final OAuthState oauthState;
    private final String resourceOwnerId;
    private final String refreshTokenCondition;

    public OAuthRestConnection(String baseUri, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, OAuthState oauthState, String resourceOwnerId, ExpressionLanguage expressionLanguage, String refreshTokenCondition) {
        super(baseUri, configName, httpClient, authentication, defaultQueryParams, defaultHeaders, expressionLanguage);
        this.refreshTokenCondition = refreshTokenCondition;
        Preconditions.checkArgument((resourceOwnerId != null ? 1 : 0) != 0, (String)"resourceOwnerId cannot be null");
        this.resourceOwnerId = resourceOwnerId;
        Preconditions.checkArgument((oauthState != null ? 1 : 0) != 0, (String)"oauthState cannot be null");
        this.oauthState = oauthState;
    }

    @Override
    protected HttpRequest buildRequest(RestRequestBuilder requestBuilder) {
        requestBuilder.addHeader("Authorization", "Bearer " + this.oauthState.getAccessToken());
        return super.buildRequest(requestBuilder);
    }

    private BindingContext buildContext(HttpResponse response, RestError error, MediaType defaultResponseMediaType) {
        Result result = this.toResult(response, true, defaultResponseMediaType, null);
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", new TypedValue(result.getOutput(), DataType.builder().mediaType(result.getMediaType().orElse(MediaType.ANY)).build())).addBinding("attributes", new TypedValue((Object)result.getAttributes(), DataType.builder().mediaType(result.getAttributesMediaType().orElse(MediaType.ANY)).build()));
        return builder.build();
    }

    public Optional<String> getRefreshTokenCondition() {
        return Optional.ofNullable(this.refreshTokenCondition);
    }

    private ExpressionLanguage requireExpressionLanguage() {
        return this.getExpressionLanguage().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"No expression language support to execute OAuth2 RefreshTokenCondition expression.")));
    }

    private boolean needsRefresh(HttpResponse response, RestError error, MediaType defaultResponseMediaType) {
        String refreshTokenCondition = this.getRefreshTokenCondition().orElse(null);
        if (refreshTokenCondition != null) {
            try {
                return (Boolean)this.requireExpressionLanguage().evaluate(refreshTokenCondition, DataType.BOOLEAN, this.buildContext(response, error, defaultResponseMediaType)).getValue();
            }
            catch (ExpressionExecutionException | ExpressionRuntimeException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to execute defined OAuth2 RefreshTokenCondition expression."), e);
            }
        }
        return error == RestError.UNAUTHORIZED;
    }

    @Override
    protected void handleResponseError(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, RestError error) {
        if (this.needsRefresh(response, error, defaultResponseMediaType)) {
            future.completeExceptionally(new AccessTokenExpiredException(this.resourceOwnerId));
        } else {
            super.handleResponseError(response, defaultResponseMediaType, future, streamingHelper, error);
        }
    }
}

