/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.api.operation;

import com.mulesoft.connectivity.mule.api.operation.ResultError;
import java.util.Objects;
import java.util.function.Function;

public abstract class OperationResult<T> {
    private OperationResult() {
    }

    public abstract boolean isSuccess();

    public abstract T getValue();

    public abstract ResultError getErrorValue();

    public abstract <Z> OperationResult<Z> map(Function<? super T, ? extends Z> var1);

    public static <T> OperationResult<T> success(T value) {
        return new SuccessfulOperationResult(Objects.requireNonNull(value));
    }

    public static <T> OperationResult<T> failure(ResultError errorValue) {
        return new FailedOperationResult(Objects.requireNonNull(errorValue, "The error value must not be null"));
    }

    private static class SuccessfulOperationResult<T>
    extends OperationResult<T> {
        private final T value;

        private SuccessfulOperationResult(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public ResultError getErrorValue() {
            throw new IllegalStateException("Tried to access an error value from a successful result");
        }

        @Override
        public <Z> OperationResult<Z> map(Function<? super T, ? extends Z> mapper) {
            return SuccessfulOperationResult.success(Objects.requireNonNull(mapper).apply(this.value));
        }

        public String toString() {
            return "SUCCESS: " + this.getValue();
        }
    }

    private static class FailedOperationResult<T>
    extends OperationResult<T> {
        private final ResultError errorValue;

        private FailedOperationResult(ResultError errorValue) {
            this.errorValue = errorValue;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public T getValue() {
            throw new IllegalStateException("Tried to access a value from a failed result");
        }

        @Override
        public ResultError getErrorValue() {
            return this.errorValue;
        }

        @Override
        public <Z> OperationResult<Z> map(Function<? super T, ? extends Z> mapper) {
            Objects.requireNonNull(mapper);
            return this;
        }

        public String toString() {
            return "ERROR: " + this.getErrorValue();
        }
    }
}

