/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.connection;

import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationTypeVisitor;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ApiKeyHttpAuthenticationType
extends HttpAuthenticationType {
    private final In in;
    private final String name;

    public ApiKeyHttpAuthenticationType(@Nullable String subType, In in, String name) {
        super(HttpAuthenticationType.Type.apiKey, subType);
        this.in = Objects.requireNonNull(in, "'in' cannot be null");
        this.name = Objects.requireNonNull(name, "'name' cannot be null");
    }

    public In getIn() {
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void accept(AuthenticationTypeVisitor authenticationTypeVisitor) {
        authenticationTypeVisitor.visitApiKeyHttpAuthenticationType(this);
    }

    @Override
    public String toString() {
        return "ApiKeyHttpAuthenticationType{type=" + String.valueOf((Object)this.getType()) + ", subType='" + String.valueOf(this.getSubType()) + "', in=" + String.valueOf((Object)this.in) + ", name='" + this.name + "'}";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApiKeyHttpAuthenticationType that = (ApiKeyHttpAuthenticationType)o;
        return this.getType() == that.getType() && Objects.equals(this.getSubType(), that.getSubType()) && this.in == that.in && this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getType(), this.getSubType(), this.in, this.name});
    }

    public static enum In {
        header,
        cookie,
        query;


        public static In fromString(String value) {
            return switch (value) {
                case "header" -> header;
                case "cookie" -> cookie;
                case "query" -> query;
                default -> throw new IllegalArgumentException("Unsupported In: " + value);
            };
        }
    }
}

