/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.internal.ModelReferenceParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.sdk.NameIdentifierHelper;

public class CodeSourceLocation {
    public static final Integer HIGHER_ORDER = 100;
    private final int order;
    private final int moduleParts;
    private final List<String> parts;
    private final List<AnnotationInfo> annotations;

    private CodeSourceLocation(int moduleParts, List<String> parts, List<AnnotationInfo> annotations, int order) {
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Your location should at least have one part");
        }
        if (parts.size() < moduleParts) {
            throw new IllegalArgumentException("You cannot have more module parts than the total part count");
        }
        this.parts = parts;
        this.moduleParts = moduleParts;
        this.annotations = annotations;
        this.order = order;
    }

    private CodeSourceLocation(int moduleParts, List<String> parts, List<AnnotationInfo> annotations) {
        this(moduleParts, parts, annotations, HIGHER_ORDER);
    }

    public static @Nullable CodeSourceLocation from(@Nullable String modelReference) {
        if (modelReference == null || modelReference.isEmpty()) {
            return null;
        }
        ModelReferenceParser.Result result = ModelReferenceParser.parse(modelReference);
        return new CodeSourceLocation(result.getModuleDepth(), result.getParts(), List.of());
    }

    public static @Nullable CodeSourceLocation from(@Nullable List<String> moduleParts) {
        if (moduleParts == null || moduleParts.isEmpty()) {
            return null;
        }
        CodeSourceLocation location = CodeSourceLocation.module(moduleParts.get(0));
        for (int i = 1; i < moduleParts.size(); ++i) {
            location = location.submodule(moduleParts.get(i));
        }
        return location;
    }

    public boolean isModuleReference() {
        return this.parts.size() - this.moduleParts == 0;
    }

    public boolean isVariableReference() {
        return this.parts.size() - this.moduleParts == 1;
    }

    public boolean isFieldReference() {
        return this.parts.size() - this.moduleParts > 1;
    }

    public CodeSourceLocation assertFieldOrVariableReference() {
        if (!this.isVariableReference() && !this.isFieldReference()) {
            throw new IllegalStateException("Expected `" + String.valueOf(this) + "` to be a field or variable reference");
        }
        return this;
    }

    public CodeSourceLocation variable(String variableName) {
        if (!this.isModuleReference()) {
            throw new UnsupportedOperationException("You can only get a variable reference from a module reference");
        }
        if (!CodeSourceLocation.isValidIdentifier(variableName)) {
            throw new IllegalArgumentException("Variable names cannot have special characters");
        }
        String[] newParts = this.parts.toArray(new String[this.parts.size() + 1]);
        newParts[newParts.length - 1] = variableName;
        return new CodeSourceLocation(this.moduleParts, List.of(newParts), List.of(), this.order);
    }

    public CodeSourceLocation submodule(String moduleName) {
        if (!this.isModuleReference()) {
            throw new UnsupportedOperationException("You can only get a module reference from a module reference");
        }
        if (!CodeSourceLocation.isValidIdentifier(moduleName)) {
            throw new IllegalArgumentException("Module names cannot have special characters");
        }
        String[] newParts = this.parts.toArray(new String[this.parts.size() + 1]);
        newParts[newParts.length - 1] = moduleName;
        return new CodeSourceLocation(this.moduleParts + 1, List.of(newParts), List.of(), this.order);
    }

    public CodeSourceLocation field(String fieldName) {
        if (!this.isFieldReference() && !this.isVariableReference()) {
            throw new UnsupportedOperationException("You cannot do a field reference on a module reference (you have to refer to a variable first)");
        }
        String[] newParts = this.parts.toArray(new String[this.parts.size() + 1]);
        newParts[newParts.length - 1] = fieldName;
        return new CodeSourceLocation(this.moduleParts, List.of(newParts), List.of(), this.order);
    }

    public static CodeSourceLocation module(String moduleReference) {
        String[] parts;
        for (String part : parts = moduleReference.split("::")) {
            if (CodeSourceLocation.isValidIdentifier(part)) continue;
            throw new IllegalArgumentException("The package `" + moduleReference + "` has an invalid name");
        }
        return new CodeSourceLocation(parts.length, List.of(parts), List.of());
    }

    public CodeSourceLocation withAnnotations(List<AnnotationInfo> annotations) {
        boolean validAnnotations = annotations.stream().map(AnnotationInfo::getAnnotation).allMatch(CodeSourceLocation::isVariableReference);
        if (this.isModuleReference()) {
            throw new UnsupportedOperationException("Module references cannot be annotated");
        }
        if (!validAnnotations) {
            throw new IllegalArgumentException("Annotations can only be variable references");
        }
        return new CodeSourceLocation(this.moduleParts, this.parts, Collections.unmodifiableList(annotations), this.order);
    }

    public CodeSourceLocation addAnnotations(List<AnnotationInfo> extraAnnotations) {
        ArrayList<AnnotationInfo> newAnnotations = new ArrayList<AnnotationInfo>(this.annotations);
        newAnnotations.addAll(extraAnnotations);
        return this.withAnnotations(newAnnotations);
    }

    public CodeSourceLocation addAnnotation(CodeSourceLocation annotation, Map<String, Object> params, boolean prefersExpressionPlacement) {
        return this.addAnnotations(List.of(new AnnotationInfo(annotation, params, prefersExpressionPlacement)));
    }

    public CodeSourceLocation withOrder(int order) {
        if (order < 0 || order > HIGHER_ORDER) {
            throw new IllegalArgumentException("Invalid order priority: " + order + ". Valid range is [0, " + HIGHER_ORDER + "]");
        }
        return new CodeSourceLocation(this.moduleParts, this.parts, this.annotations, order);
    }

    public List<String> getModuleParts() {
        return this.parts.subList(0, this.moduleParts);
    }

    public List<String> getFieldParts() {
        return this.parts.subList(this.moduleParts + 1, this.parts.size());
    }

    public List<String> getVariableParts() {
        return this.parts.subList(this.moduleParts, this.parts.size());
    }

    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public String getVariableName() {
        if (!this.isVariableReference() && !this.isFieldReference()) {
            throw new UnsupportedOperationException("The place pointed by this location does not include a variable reference");
        }
        return this.parts.get(this.moduleParts);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public CodeSourceLocation getParent() {
        if (this.parts.size() == 1) {
            throw new UnsupportedOperationException("Cannot get the parent for a base module");
        }
        int newModuleParts = this.isModuleReference() ? this.moduleParts - 1 : this.moduleParts;
        List<String> newParts = this.parts.subList(0, this.parts.size() - 1);
        return new CodeSourceLocation(newModuleParts, newParts, List.of(), this.order);
    }

    public int getOrder() {
        return this.order;
    }

    private static boolean isValidIdentifier(String text) {
        return NameIdentifierHelper.isValidIdentifier((String)text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parts.get(0));
        for (int i = 1; i < this.parts.size(); ++i) {
            if (i <= this.moduleParts) {
                sb.append("::");
            } else {
                sb.append('.');
            }
            String part = this.parts.get(i);
            if (!CodeSourceLocation.isValidIdentifier(part)) {
                sb.append('\"');
                sb.append(part);
                sb.append('\"');
                continue;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeSourceLocation location = (CodeSourceLocation)o;
        return this.moduleParts == location.moduleParts && Objects.equals(this.parts, location.parts);
    }

    public int hashCode() {
        return Objects.hash(this.moduleParts, this.parts);
    }

    public static class AnnotationInfo {
        private final CodeSourceLocation annotation;
        private final Map<String, Object> parameters;
        private final boolean prefersExpressionPlacement;

        public AnnotationInfo(CodeSourceLocation annotation, Map<String, Object> parameters, boolean prefersExpressionPlacement) {
            this.annotation = annotation;
            this.parameters = parameters;
            this.prefersExpressionPlacement = prefersExpressionPlacement;
        }

        public CodeSourceLocation getAnnotation() {
            return this.annotation;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public boolean prefersExpressionPlacement() {
            return this.prefersExpressionPlacement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationInfo that = (AnnotationInfo)o;
            return this.prefersExpressionPlacement == that.prefersExpressionPlacement && Objects.equals(this.annotation, that.annotation) && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.annotation, this.parameters, this.prefersExpressionPlacement);
        }
    }
}

