/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import java.util.ArrayList;
import java.util.List;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.structure.KeyNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.parser.phase.AbstractParsingAnnotationProcessor;
import org.mule.weave.v2.parser.phase.ParsingPhaseAnnotationContext;
import org.mule.weave.v2.sdk.NameIdentifierHelper;

public class ReferencesAnnotationProcessor
extends AbstractParsingAnnotationProcessor {
    private final List<String> references = new ArrayList<String>();

    public void run(AstNode annotatedNode, AnnotationNode annotation, ParsingPhaseAnnotationContext context) {
        try {
            if (annotatedNode instanceof VarDirective || annotatedNode instanceof VariableReferenceNode || annotatedNode instanceof ObjectNode || annotatedNode instanceof FunctionCallNode) {
                this.references.add(this.generateRef(annotatedNode, context));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private String generateRef(AstNode node, ParsingPhaseAnnotationContext context) {
        if (node instanceof VarDirective) {
            VarDirective varNode = (VarDirective)node;
            return varNode.location().resourceName().toString() + "::" + varNode.nameIdentifier().name();
        }
        if (node instanceof KeyValuePairNode) {
            KeyValuePairNode keyValuePairNode = (KeyValuePairNode)node;
            KeyNode keyNode = (KeyNode)keyValuePairNode.key();
            AstNode astNode = keyNode.keyName();
            if (!(astNode instanceof StringNode)) {
                throw new RuntimeException("key name : " + keyNode.keyName().toString() + " must be string node");
            }
            StringNode stringNode = (StringNode)astNode;
            Object nodeStringValue = NameIdentifierHelper.isValidIdentifier((String)stringNode.value()) ? stringNode.value() : "\"" + stringNode.value() + "\"";
            return this.generateRef((AstNode)context.astNavigator().parentOf(node).get(), context) + "." + (String)nodeStringValue;
        }
        if (node instanceof ObjectNode || node instanceof VariableReferenceNode || node instanceof FunctionCallNode) {
            return this.generateRef((AstNode)context.astNavigator().parentOf(node).get(), context);
        }
        throw new RuntimeException("Node : " + String.valueOf(node.getClass()) + "not handled");
    }

    public List<String> getReferences() {
        return this.references;
    }
}

