/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.annotation.DWAbstractParsingAnnotationProcessor;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationContext;
import org.mule.weave.v2.api.tooling.ast.DWAstNode;
import org.mule.weave.v2.api.tooling.ast.DWAstNodeHelper;
import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind;
import org.mule.weave.v2.api.tooling.impl.message.DefaultMessageBuilder;
import org.mule.weave.v2.api.tooling.message.Message;
import org.mule.weave.v2.api.tooling.message.ValidationMessage;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;

public class ConnectorDiscoveryAnnotationProcessor
extends DWAbstractParsingAnnotationProcessor {
    private final List<String> connectorVariableNames = new ArrayList<String>();
    private final NameIdentifier annotationName;

    public ConnectorDiscoveryAnnotationProcessor(NameIdentifier annotationName) {
        this.annotationName = annotationName;
    }

    public void run(DWAstNode annotatedNode, DWAstNode annotation, DWAnnotationContext context) {
        if (annotatedNode.getKind().equals(DWAstNodeKind.VAR_DIRECTIVE_NODE())) {
            Optional<DWAstNode> nameIdentifier = Arrays.stream(DWAstNodeHelper.getChildrenByKind((DWAstNode)annotatedNode, (String)DWAstNodeKind.NAME_IDENTIFIER())).findFirst();
            if (nameIdentifier.isPresent()) {
                Optional value = nameIdentifier.get().getValue();
                value.ifPresent(this.connectorVariableNames::add);
            }
        } else {
            Message message = new DefaultMessageBuilder().withKind("ConnectorAnnotationCanOnlyBeDefinedForVariables").withMessage("Only variables can be annotated with @" + String.valueOf(this.annotationName) + " node: " + annotatedNode.getClass().getName() + " is not supported").build();
            context.getMessageCollector().addErrorValidationMessage(new ValidationMessage(message, annotatedNode.getLocation()));
        }
    }

    public List<String> getConnectorVariableNames() {
        return Collections.unmodifiableList(this.connectorVariableNames);
    }
}

