/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.model.EagerPage;
import com.mulesoft.connectivity.linkweave.api.model.Page;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.core.exception.UserException;

public class LazyPage<T>
implements Page<T> {
    private final DataWeaveLiveValue liveValue;

    public LazyPage(DataWeaveLiveValue liveValue) {
        this.liveValue = liveValue;
    }

    @Override
    public List<T> getItems() {
        return new AbstractList<T>(){
            @Nullable Integer size = null;

            @Override
            public T get(int index) {
                try (DataWeaveCall call = LazyPage.this.liveValue.call();){
                    call.bind("i", index);
                    Object t = LazyPage.this.getItem(call);
                    return t;
                }
            }

            @Override
            public int size() {
                if (this.size == null) {
                    this.size = (Integer)Objects.requireNonNull(LazyPage.this.liveValue.run("sizeOf(result.items)"));
                }
                return this.size;
            }
        };
    }

    protected T getItem(DataWeaveCall call) {
        return (T)call.write("result.items[i]");
    }

    public Iterator<Content> getRawItems() {
        return new Iterator<Content>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                try (DataWeaveCall call = LazyPage.this.liveValue.call();){
                    call.bind("i", this.i);
                    boolean bl = Boolean.TRUE.equals(call.write("result.items[i]?"));
                    return bl;
                }
            }

            @Override
            public Content next() {
                DataWeaveCall call = LazyPage.this.liveValue.call();
                try {
                    call.bind("i", this.i++);
                    Content content = new Content(call.execute("if (result.items[i]?)\n  result.items[i] <~ result.^\nelse\n  dw::Runtime::fail(\"EOF\")\n"), true);
                    if (call != null) {
                        call.close();
                    }
                    return content;
                }
                catch (Throwable throwable) {
                    try {
                        if (call != null) {
                            try {
                                call.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UserException e) {
                        if (e.getMessage().startsWith("EOF")) {
                            throw new NoSuchElementException();
                        }
                        throw e;
                    }
                }
            }
        };
    }

    @Override
    public Optional<Serializable> getNextPage() {
        return Optional.ofNullable((Serializable)this.liveValue.run("result.nextPage"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64).append("Page{items=").append(this.getItems());
        this.getNextPage().ifPresent(np -> sb.append(", nextPage=").append(np));
        return sb.append('}').toString();
    }

    public boolean equals(@Nullable Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void close() {
        this.liveValue.close();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new EagerPage<T>(this.getItems(), this.getNextPage().orElse(null));
    }
}

