/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.api.version;

/**
 * Validator for potential {@link ArtifactVersion versions}. Lets you validate whether your parameter is correct for
 * successfully creating an {@link ArtifactVersion} using an {@link ArtifactVersionFactory}.
 */
public interface ArtifactVersionValidator {

  /**
   * Returns whether the string representing a version is valid for constructing an instance using {@link
   * ArtifactVersionFactory#create(String)}.
   *
   * @param version to validate.
   * @return true/false depending if the version is valid or not.
   */
  boolean isValid(String version);
}
