/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.api;

import com.mulesoft.anypoint.discovery.api.exception.NoLatestVersionFoundException;
import com.mulesoft.anypoint.discovery.api.exception.VersionDiscoveryException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;

import java.util.List;


/**
 * Provides all the available {@link Runtime} {@link ArtifactVersion versions}.
 * <p>
 * NOTE: Depending on the implementation, this provider may throw instance of {@link NoLatestVersionFoundException} or
 * {@link VersionDiscoveryException} if unable to properly detect available versions.
 */
public interface RuntimeVersionProvider {

  /**
   * @return all the available {@link ArtifactVersion}s.
   */
  List<ArtifactVersion> all();

  /**
   * @return the latest available {@link ArtifactVersion}.
   */
  ArtifactVersion latest();
}
