/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyTemplateDto;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateAssetException;
import com.mulesoft.mule.runtime.gw.policies.template.provider.GatewayPolicyTemplateDescriptorFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import java.io.InputStream;
import org.mule.runtime.api.util.Preconditions;

public class FileSystemPolicyTemplateProvider
extends PolicyTemplateProvider {
    private final ApiPlatformClient restClient;

    public FileSystemPolicyTemplateProvider(ApiPlatformClient restClient, GatewayPolicyTemplateDescriptorFactory templateDescriptorFactory, PolicyTemplateStore policyTemplateStore) {
        super(templateDescriptorFactory, policyTemplateStore);
        this.restClient = restClient;
    }

    @Override
    protected PolicyTemplateAssets getPolicyTemplateAssets(PolicyTemplateKey templateKey) {
        PolicyTemplateAssets policyTemplateAssets = this.getTemplateFiles(templateKey);
        Preconditions.checkState((boolean)policyTemplateAssets.getTemplateJarFile().exists(), (String)("Could not find policy Jar template " + templateKey.getName()));
        return policyTemplateAssets;
    }

    private PolicyTemplateAssets getTemplateFiles(PolicyTemplateKey templateKey) {
        PolicyTemplateAssets templateAssets = this.policyTemplateStore.getTemplateAssets(templateKey);
        if (!templateAssets.getTemplateJarFile().exists()) {
            PolicyTemplateDto template;
            LOGGER.debug("Policy template {} assets are not present in the runtime. Fetching metadata for assets...", (Object)templateKey);
            try {
                template = this.restClient.getPolicyTemplateMetadata(templateKey);
            }
            catch (Exception e) {
                throw new PolicyTemplateAssetException("Unexpected error when requesting template metadata for policy " + templateKey.getName(), e);
            }
            this.downloadFiles(templateKey, template.getJarDownloadLink(), template.getYamlDownloadLink());
        }
        return templateAssets;
    }

    private void downloadFiles(PolicyTemplateKey templateKey, String jarLink, String yamlLink) {
        InputStream inputStream;
        LOGGER.debug("Starting download of policy template assets {}", (Object)templateKey);
        try {
            inputStream = this.restClient.downloadTemplateAsset(jarLink);
            this.policyTemplateStore.storeJar(templateKey, inputStream);
            LOGGER.debug("Policy template jar {} successfully downloaded", (Object)templateKey);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to save jar file from link {} for {}", (Object)jarLink, (Object)templateKey);
            throw new PolicyTemplateAssetException("Unexpected error trying to download policy template asset" + templateKey.getName(), e);
        }
        try {
            inputStream = this.restClient.downloadTemplateAsset(yamlLink);
            this.policyTemplateStore.storeYaml(templateKey, inputStream);
            LOGGER.debug("Policy template yaml {} successfully downloaded", (Object)templateKey);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to save yaml file from link {} for {}", (Object)yamlLink, (Object)templateKey);
        }
    }
}

