/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultPolicyDeploymentTracker
implements PolicyDeploymentTracker {
    private List<PolicyDeploymentListener> listeners = new LinkedList<PolicyDeploymentListener>();
    private Map<ApiKey, Map<String, PolicyDeploymentStatus>> policies = new HashMap<ApiKey, Map<String, PolicyDeploymentStatus>>();

    @Override
    public List<PolicyDefinition> apiRemoved(ApiKey apiKey) {
        return this.policies.containsKey(apiKey) ? this.policies.remove(apiKey).values().stream().map(PolicyDeploymentStatus::getLatestPolicyStatus).map(PolicyDefinitionDeploymentStatus::getPolicyDefinition).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public void addPolicyDeploymentListener(PolicyDeploymentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void policyRemoved(ApiKey apiKey, String policyId) {
        Optional.ofNullable((PolicyDeploymentStatus)this.policies.getOrDefault(apiKey, Collections.emptyMap()).remove(policyId)).ifPresent(status -> this.listeners.forEach(listener -> listener.policyRemoved(apiKey, (PolicyDeploymentStatus)status)));
    }

    @Override
    public void policyDeployed(ApiKey apiKey, PolicyDeploymentStatus policyDeploymentStatus) {
        this.policies.putIfAbsent(apiKey, new HashMap());
        this.policies.get(apiKey).put(policyDeploymentStatus.getLatestPolicyStatus().getPolicyDefinition().getId(), policyDeploymentStatus);
        this.listeners.forEach(listener -> listener.policyDeployed(apiKey, policyDeploymentStatus));
    }

    @Override
    public Optional<PolicyDeploymentStatus> policyStatus(ApiKey apiKey, String policyId) {
        return Optional.ofNullable((PolicyDeploymentStatus)this.policies.getOrDefault(apiKey, Collections.emptyMap()).get(policyId));
    }

    @Override
    public List<PolicyDeploymentStatus> onlinePolicyStatuses(ApiKey apiKey) {
        return this.policies.getOrDefault(apiKey, Collections.emptyMap()).values().stream().filter(status -> status.getLatestPolicyStatus().getPolicyDefinition().isOnline()).collect(Collectors.toList());
    }

    @Override
    public List<PolicyDeploymentStatus> policyStatuses(ApiKey apiKey) {
        return new ArrayList<PolicyDeploymentStatus>(this.policies.getOrDefault(apiKey, Collections.emptyMap()).values());
    }

    @Override
    public Optional<PolicyDefinition> findById(String policyId) {
        return this.policies.values().stream().flatMap(policies -> policies.values().stream()).map(PolicyDeploymentStatus::getLatestPolicyStatus).map(PolicyDefinitionDeploymentStatus::getPolicyDefinition).filter(policyDefinition -> policyDefinition.getId().equals(policyId)).findFirst();
    }

    @Override
    public boolean policyHasDeployments(String policyId) {
        return this.policies.values().stream().flatMap(policies -> policies.values().stream()).map(PolicyDeploymentStatus::getLatestPolicyStatus).anyMatch(policyStatus -> policyStatus.getPolicyDefinition().getId().equals(policyId));
    }
}

