/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.ListOfKeyvaluesTypeFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListOfKeyvaluesEncrypter
extends PolicyTypeEncrypter<List<Map<String, Object>>> {
    public ListOfKeyvaluesEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled, List<PolicyProperty> policyProperties) {
        super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
    }

    @Override
    protected EncryptedValueResult encryptSingle(String rootKey, List<Map<String, Object>> keyvalues) {
        ArrayList templateList = new ArrayList();
        ArrayList<Map<String, Object>> configurationList = new ArrayList<Map<String, Object>>();
        this.flatten(keyvalues).forEach((key, value) -> {
            String templateValue = String.join((CharSequence)"", "${secure::", rootKey, ".", key, "}");
            String configurationValue = this.encrypt((String)value);
            LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>();
            templateMap.put("key", (String)key);
            templateMap.put("value", templateValue);
            LinkedHashMap<String, String> configurationMap = new LinkedHashMap<String, String>();
            configurationMap.put("key", (String)key);
            configurationMap.put("value", configurationValue);
            templateList.add(templateMap);
            configurationList.add(configurationMap);
        });
        Map<String, Object> configFile = this.flatten(configurationList);
        return new EncryptedValueResult<Map<String, Object>>(rootKey, (Map<String, Object>)((Object)templateList), (Map<String, Object>)((Object)configurationList), configFile);
    }

    @Override
    protected EncryptedValueResult decryptSingle(String key, List<Map<String, Object>> keyvalues) {
        List updated = keyvalues.stream().map(keyvalue -> {
            HashMap decrypted = new HashMap();
            decrypted.put("key", keyvalue.get("key"));
            decrypted.put("value", this.decrypt((String)keyvalue.get("value")));
            return decrypted;
        }).collect(Collectors.toList());
        return new EncryptedValueResult(key, updated, updated);
    }

    @Override
    protected boolean supports(String key, Optional<PolicyProperty> property) {
        return property.isPresent() && new ListOfKeyvaluesTypeFilter().test(property.get());
    }

    private Map<String, Object> flatten(List<Map<String, Object>> keyvalues) {
        return keyvalues.stream().collect(Collectors.toMap(stringObjectEntry1 -> (String)stringObjectEntry1.get("key"), stringObjectEntry12 -> stringObjectEntry12.get("value")));
    }
}

