/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck;

import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck.DefaultReadyStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck.ReadyStatusFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.healthcheck.ReadyStatus;

public class TextReadyStatusFactory
implements ReadyStatusFactory {
    private final Map<GatekeeperStatus, Function<Long, ReadyStatus>> factories = new HashMap<GatekeeperStatus, Function<Long, ReadyStatus>>();

    public TextReadyStatusFactory() {
        this.factories.put(GatekeeperStatus.AWAITING_POLICIES, this::awaitingPolicies);
        this.factories.put(GatekeeperStatus.POLICIES_FAILED, this::policiesFailed);
        this.factories.put(GatekeeperStatus.AWAITING_CONTRACTS, this::awaitingContracts);
        this.factories.put(GatekeeperStatus.AWAITING_UNBLOCK, this::awaitingUnblock);
        this.factories.put(GatekeeperStatus.AWAITING_TRACKING, this::awaitingTracking);
        this.factories.put(GatekeeperStatus.UNTRACKED, this::untracked);
        this.factories.put(GatekeeperStatus.READY, this::ready);
    }

    @Override
    public ReadyStatus readyStatus(Long apiId, GatekeeperStatus gatekeeperStatus) {
        return this.factories.get(gatekeeperStatus).apply(apiId);
    }

    @Override
    public ReadyStatus missingApi(Long apiId) {
        return this.blockedStatus(apiId, "API was not deployed.");
    }

    @Override
    public ReadyStatus readyStatus(List<ReadyStatus> statusList) {
        if (statusList.size() == 1) {
            return statusList.get(0);
        }
        boolean readyStatus = statusList.stream().allMatch(ReadyStatus::isReady);
        String message = statusList.stream().map(ReadyStatus::statusDescription).flatMap(description -> description.map(Stream::of).orElseGet(Stream::empty)).sorted().collect(Collectors.joining("\n"));
        return new DefaultReadyStatus(readyStatus, this.appMessage(readyStatus) + message);
    }

    private String appMessage(boolean readyStatus) {
        return readyStatus ? "" : "Gatekeeper is blocking the app due to:\n";
    }

    protected ReadyStatus awaitingPolicies(Long apiId) {
        return this.blockedStatus(apiId, "Waiting for policies to be applied.");
    }

    protected ReadyStatus policiesFailed(Long apiId) {
        return this.blockedStatus(apiId, "Error applying policies.");
    }

    protected ReadyStatus awaitingContracts(Long apiId) {
        return this.blockedStatus(apiId, "Waiting for API's client applications to be successfully retrieved.");
    }

    protected ReadyStatus awaitingUnblock(Long apiId) {
        return this.blockedStatus(apiId, "Unblocking requirements met, API should be unblocked shortly.");
    }

    protected ReadyStatus awaitingTracking(Long apiId) {
        return this.blockedStatus(apiId, "Awaiting for successful API tracking.");
    }

    protected ReadyStatus untracked(Long apiId) {
        return this.blockedStatus(apiId, "API not found in the API Platform.");
    }

    protected ReadyStatus ready(Long apiId) {
        return new DefaultReadyStatus(true, String.format("API %s: Ready.", apiId));
    }

    protected ReadyStatus blockedStatus(Long apiId, String message) {
        return new DefaultReadyStatus(false, String.format("API %s: Not Ready. %s", apiId, message));
    }
}

