/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics.sender;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.retry.barrier.BackoffWhilstAlone;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.sender.MetricsSenderRunnable;
import com.mulesoft.mule.runtime.gw.metrics.sender.StatusListener;
import com.mulesoft.mule.runtime.gw.metrics.serialization.EventMapper;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsScheduler
implements StatusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsScheduler.class);
    private BackoffScheduler backoffScheduler;
    private ApiPlatformClient apiPlatformClient;
    private MetricsSenderRunnable metricsSenderRunnable;
    private SizeLimitedQueue<Event> senderEventQueue;
    private String uuid;

    public MetricsScheduler(String uuid, SizeLimitedQueue<Event> senderEventQueue, ApiPlatformClient apiPlatformClient, ScheduledExecutorService executorService) {
        this.uuid = uuid;
        this.apiPlatformClient = apiPlatformClient;
        this.senderEventQueue = senderEventQueue;
        this.backoffScheduler = new VariableExecutorBackoffSchedulerFactory().create(executorService);
    }

    public void initialise() throws InitialisationException {
        LOGGER.debug("Starting Metrics scheduler for pushing events.");
        BackoffConfiguration backoffConfiguration = new BackoffConfiguration.Builder(new GatewayConfiguration().platformClient().backoffEnabled().booleanValue()).build();
        this.metricsSenderRunnable = new MetricsSenderRunnable(this.metricsEventMapper(), this.senderEventQueue, this.apiPlatformClient, backoffConfiguration, (BackoffBarrier)new BackoffWhilstAlone());
        this.backoffScheduler.scheduleWithFixedDelay((BackoffRunnable)this.metricsSenderRunnable, this.metricsSchedulerConfiguration());
    }

    public void dispose() {
        this.backoffScheduler.dispose();
    }

    private EventMapper metricsEventMapper() {
        return new EventMapper(this.uuid, this.apiPlatformClient.getRootOrgId());
    }

    private SchedulingConfiguration metricsSchedulerConfiguration() {
        return SchedulingConfiguration.configuration((Period)Period.seconds((int)0), (Period)Period.seconds((int)new GatewayConfiguration().metrics().getMetricsPushEventsFrequency()));
    }
}

