/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.hdp.registry;

import com.mulesoft.mule.runtime.gw.api.folders.PolicyFolders;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.hdp.registry.ApiRegistryListener;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRegistryWatcher
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiRegistryWatcher.class);
    private static final long POLLING_INTERVAL = 100L;
    private final FileAlterationMonitor monitor;
    private final FileAlterationListener listener;
    private final String artifactName;

    public ApiRegistryWatcher(ApiService apiService, String artifactName) {
        this.artifactName = artifactName;
        this.monitor = new FileAlterationMonitor(100L);
        this.listener = new ApiRegistryListener(apiService, artifactName);
    }

    public void initialise() {
        FileAlterationObserver observer = new FileAlterationObserver(PolicyFolders.getApiRegistryFolder(), (FileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.nameFileFilter((String)this.getFileName())));
        observer.addListener(this.listener);
        this.monitor.addObserver(observer);
        this.monitor.setThreadFactory(r -> {
            Thread t = new Thread(r);
            t.setName(String.format("agw-hdp-%s-watcher", this.artifactName));
            return t;
        });
    }

    public void start() {
        try {
            File registryFile = new File(PolicyFolders.getApiRegistryFolder(), this.getFileName());
            LOGGER.debug("High Density Proxy API registry monitor started at {}", (Object)registryFile.getCanonicalPath());
            this.monitor.start();
            if (registryFile.isFile()) {
                this.listener.onFileCreate(registryFile);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error starting High Density Proxy API registry monitor.", (Throwable)e);
        }
    }

    public void stop() {
        try {
            LOGGER.debug("High Density Proxy API registry monitor stopped for application {}" + this.artifactName);
            this.monitor.stop();
        }
        catch (Exception e) {
            LOGGER.error("Error stopping High Density Proxy API registry monitor for application " + this.artifactName, (Throwable)e);
        }
    }

    public void dispose() {
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    private String getFileName() {
        return this.artifactName + ".json";
    }
}

