/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.quorum;

import com.mulesoft.mule.runtime.gw.api.config.QuorumConfiguration;
import com.mulesoft.mule.runtime.gw.retry.FixedRetrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lock.LockFactory;

public class ClusterReadyRetrier {
    private static final String CLUSTER_READY_DEFER_NAME = "agw-cluster-ready-defer";
    private static final String CLUSTER_LOCK_CHECK_NAME = "cluster-ready-check";
    private final FixedRetrier clusterReadyRetrier;
    private final LockFactory lockFactory;

    public ClusterReadyRetrier(QuorumConfiguration quorumConfiguration, LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        this.clusterReadyRetrier = new FixedRetrier((long)quorumConfiguration.delaySeconds(), TimeUnit.SECONDS);
    }

    public void deferTillClusterReady(Runnable runnable) {
        this.clusterReadyRetrier.tryOrReschedule(CLUSTER_READY_DEFER_NAME, () -> {
            this.checkClusterReady();
            runnable.run();
        });
    }

    public void dispose() {
        this.clusterReadyRetrier.dispose();
    }

    private void checkClusterReady() {
        if (this.lockFactory == null) {
            return;
        }
        Lock lock = this.lockFactory.createLock(CLUSTER_LOCK_CHECK_NAME);
        try {
            lock.lock();
        }
        finally {
            lock.unlock();
        }
    }
}

