/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.client.exception.NonRecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import java.util.function.Function;
import org.slf4j.Logger;

public class ApiTracker
implements ApiDeploymentListener {
    private static final String TRACK_API_DESCRIPTION = "retrieve API information for API";
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiTracker.class);
    private final NormalizedExceptionMessageLogger normalizedLogger;
    private final ApiTrackingService apiTrackingService;
    private final ApiPlatformSessionFactory platformSessionFactory;

    public ApiTracker(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory) {
        this(apiTrackingService, platformSessionFactory, NonRecoverableExceptionMessageLogger::new);
    }

    public ApiTracker(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, Function<Logger, NormalizedExceptionMessageLogger> loggerSupplier) {
        this.apiTrackingService = apiTrackingService;
        this.platformSessionFactory = platformSessionFactory;
        this.normalizedLogger = loggerSupplier.apply(LOGGER);
    }

    public void onApiDeploymentSuccess(Api api) {
        this.trackApi(api);
    }

    protected void trackApi(Api api) {
        if (api.isOffline()) {
            LOGGER.debug("Tracking skipped for offline API {}", (Object)api.getKey());
            return;
        }
        ApiImplementation implementation = api.getImplementation();
        try {
            LOGGER.debug("Tracking API {}", (Object)implementation.getApiKey());
            ApiResponse apiResponse = this.platformSessionFactory.create().getApi(implementation.getApiKey());
            this.apiTrackingService.apiTracked(implementation.getApiKey(), apiResponse.getTrackingInfo(), apiResponse.getPolicySet(), apiResponse.getSlas());
            LOGGER.debug("API {} successfully tracked. API name is {} and version is {} ", new Object[]{implementation.getApiKey(), apiResponse.getTrackingInfo().getInstanceName(), apiResponse.getTrackingInfo().getVersion()});
        }
        catch (NotFoundException e) {
            LOGGER.warn("API with ID {} does not exist in API Platform for the current organization.", (Object)implementation.getApiKey().id());
            this.apiTrackingService.apiUntracked(implementation.getApiKey());
        }
        catch (IncompatibleApiException e) {
            LOGGER.error("There was an error trying to track API {}. {}", (Object)implementation.getApiKey().id(), (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        catch (Throwable t) {
            this.normalizedLogger.error(TRACK_API_DESCRIPTION, (Object)implementation.getApiKey().id(), t);
            this.apiTrackingService.apiTrackingFailed(implementation.getApiKey());
            throw t;
        }
    }
}

