/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.notification;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class ApiNotificationManager {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiNotificationManager.class);
    private List<ApiDeploymentListener> apiDeploymentListeners = new CopyOnWriteArrayList<ApiDeploymentListener>();

    public void notifyApiDeploymentStart(Api api) {
        this.notify(this.deploymentStart(api), "API Deployment start");
    }

    public void notifyApiDeploymentSuccess(Api api) {
        this.notify(this.deploymentSuccess(api), "API Deployment success");
    }

    public void notifyApiUndeploymentStart(ApiImplementation implementation) {
        this.notify(this.undeploymentStart(implementation), "API Undeployment start");
    }

    public void notifyApiRedeploymentStart(ApiImplementation implementation) {
        this.notify(this.redeploymentStart(implementation), "API Redeployment start");
    }

    public void addApiDeploymentListener(ApiDeploymentListener apiDeploymentListener) {
        this.apiDeploymentListeners.add(apiDeploymentListener);
    }

    public void removeApiDeploymentListener(ApiDeploymentListener apiDeploymentListener) {
        this.apiDeploymentListeners.remove(apiDeploymentListener);
    }

    private void notify(Consumer<ApiDeploymentListener> notification, String description) {
        this.apiDeploymentListeners.forEach(listener -> {
            try {
                notification.accept((ApiDeploymentListener)listener);
            }
            catch (Exception e) {
                LOGGER.warn("Error on {} listener: {}", (Object)description, (Object)e.getMessage());
            }
        });
    }

    private Consumer<ApiDeploymentListener> deploymentStart(Api api) {
        return listener -> listener.onApiDeploymentStart(api);
    }

    private Consumer<ApiDeploymentListener> deploymentSuccess(Api api) {
        return listener -> listener.onApiDeploymentSuccess(api);
    }

    private Consumer<ApiDeploymentListener> undeploymentStart(ApiImplementation implementation) {
        return listener -> listener.onApiUndeploymentStart(implementation);
    }

    private Consumer<ApiDeploymentListener> redeploymentStart(ApiImplementation implementation) {
        return listener -> listener.onApiRedeploymentStart(implementation);
    }
}

