/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients;

import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class PlatformClientsRetriever
implements ApiContractsListener {
    private static final String OBTAIN_CONTRACT_DESCRIPTION = "obtain contracts for API";
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(PlatformClientsRetriever.class);
    private final NormalizedExceptionMessageLogger normalizedLogger = new RecoverableExceptionMessageLogger(LOGGER);
    private final ApiPlatformSessionFactory platformSessionFactory;
    private final ApiTrackingService apiTrackingService;

    public PlatformClientsRetriever(ApiPlatformSessionFactory platformSessionFactory, ApiTrackingService apiTrackingService) {
        this.platformSessionFactory = platformSessionFactory;
        this.apiTrackingService = apiTrackingService;
    }

    public SessionMetadata retrieve(List<Api> apis) {
        ApiPlatformSession platform = this.platformSessionFactory.create();
        apis.forEach(api -> this.retrieve(platform, (Api)api));
        return platform.metadata();
    }

    public void onContractsRequired(Api api) {
        ApiPlatformSession platform;
        try {
            platform = this.platformSessionFactory.create();
        }
        catch (Throwable e) {
            this.normalizedLogger.warn(OBTAIN_CONTRACT_DESCRIPTION, (Object)api, e);
            return;
        }
        try {
            this.retrieve(platform, api);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void retrieve(ApiPlatformSession platform, Api api) {
        LOGGER.debug("Fetching clients for {}", (Object)api);
        try {
            TrackingInfo trackingInfo = api.getTrackingInfo();
            ApiClientsResponse apiClientsResponse = platform.getApiClients(trackingInfo.getOrganizationId(), trackingInfo.getEnvironmentId(), api.getKey().id(), trackingInfo.getContractsEntityTag());
            if (apiClientsResponse.hasUpdates().booleanValue()) {
                List<PlatformContractAdapter> clients = apiClientsResponse.getClients().stream().map(PlatformContractAdapter::new).filter(this::withNullIdOrSecret).collect(Collectors.toList());
                LOGGER.debug("Retrieved {} clients for {}", (Object)clients.size(), (Object)api);
                this.apiTrackingService.clientsPolling(api.getKey(), clients, apiClientsResponse.getContractsEntityTag());
            }
        }
        catch (Exception e) {
            this.normalizedLogger.warn(OBTAIN_CONTRACT_DESCRIPTION, (Object)api, (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error(String.format("Unexpected error occurred while retrieving clients for API %s. %s", api, ExceptionDescriptor.errorMessage((Throwable)e)), e);
            throw e;
        }
    }

    private boolean withNullIdOrSecret(PlatformContractAdapter contract) {
        if (contract.clientId() == null) {
            LOGGER.trace("Null clientId found for client");
            return false;
        }
        if (contract.clientSecret() == null) {
            LOGGER.trace("Null secret found for clientId");
            return false;
        }
        return true;
    }
}

