/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpResponseStatusInterceptor
implements HttpRequestResponseInterceptor {
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            this.consumePayload(httpResponse);
            throw new NotFoundException("Resource not found. Details: " + httpResponse.getStatusLine().getReasonPhrase());
        }
        if ((statusCode < 200 || statusCode >= 400) && statusCode != 401 && statusCode != 407) {
            this.consumePayload(httpResponse);
            throw new HttpResponseException("Server returned wrong status code: " + statusCode + ". Details: " + httpResponse.getStatusLine().getReasonPhrase(), statusCode);
        }
    }

    private void consumePayload(HttpResponse httpResponse) throws IOException {
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
    }
}

