/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.adapter;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.adapter.PolicyDefinitionBuilder;
import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;
import com.mulesoft.mule.runtime.gw.client.dto.LimitDto;
import com.mulesoft.mule.runtime.gw.client.dto.PolicyDefinitionDto;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.model.ApiTrackingInfo;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApiResponseBuilder {
    private PolicyDefinitionBuilder policyDefinitionBuilder = new PolicyDefinitionBuilder();
    private ApiDto api;
    private String apiEntityTag;
    private boolean noUpdates;

    public ApiResponseBuilder noUpdates() {
        this.noUpdates = true;
        return this;
    }

    public ApiResponseBuilder withApi(ApiDto api) {
        this.api = api;
        return this;
    }

    public ApiResponseBuilder withApiEntityTag(String apiEntityTag) {
        this.apiEntityTag = apiEntityTag;
        return this;
    }

    public ApiResponse build() {
        return this.noUpdates ? new ApiResponse(null, null, null, false) : new ApiResponse(this.trackingInfo(), this.policySet(), this.slas(), true);
    }

    private List<Sla> slas() {
        return this.api.getTiers().stream().filter(Objects::nonNull).map(tierDto -> new Sla(tierDto.getId(), this.mapToTiers(tierDto.getLimits()))).collect(Collectors.toList());
    }

    private PolicySet policySet() {
        List policies = this.api.getPolicies().stream().map(dto -> this.policyDefinitionBuilder.from(new ApiKey(this.api.getId()), (PolicyDefinitionDto)dto, this.api.getEndpointType(), this.api.getIdentityManagement())).collect(Collectors.toList());
        return new PolicySet(policies, PolicySet.PolicySetOrigin.PLATFORM);
    }

    private TrackingInfo trackingInfo() {
        return new ApiTrackingInfo(this.api.getId(), this.api.getInstanceName(), this.api.getGroupId(), this.api.getAssetId(), this.api.getVersion(), this.api.getOrganizationId(), this.api.getEnvironmentId(), this.api.getEndpointType(), this.api.getLegacyApiIdentifier(), this.apiEntityTag, null, this.api.getExchangeAssetName(), this.api.getProductVersion());
    }

    private List<Tier> mapToTiers(List<LimitDto> limits) {
        return limits.stream().map(limit -> new SingleTier(Integer.valueOf(limit.getMaximumRequests()), Long.valueOf(limit.getTimePeriodInMilliseconds()))).collect(Collectors.toList());
    }
}

