/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.connection;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.http.HttpClientConnection;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;

public class RestartableConnectionManager
implements HttpClientConnectionManager {
    private final AtomicReference<HttpClientConnectionManager> delegate;
    private final Supplier<HttpClientConnectionManager> supplier;

    public RestartableConnectionManager(Supplier<HttpClientConnectionManager> supplier) {
        this.supplier = supplier;
        this.delegate = new AtomicReference<HttpClientConnectionManager>(supplier.get());
    }

    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        return this.delegate.get().requestConnection(route, state);
    }

    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        this.delegate.get().releaseConnection(conn, newState, validDuration, timeUnit);
    }

    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        this.delegate.get().connect(conn, route, connectTimeout, context);
    }

    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.delegate.get().upgrade(conn, route, context);
    }

    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.delegate.get().routeComplete(conn, route, context);
    }

    public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
        this.delegate.get().closeIdleConnections(idletime, timeUnit);
    }

    public void closeExpiredConnections() {
        this.delegate.get().closeExpiredConnections();
    }

    public void shutdown() {
        this.delegate.get().shutdown();
    }

    public void restart() {
        this.delegate.getAndSet(this.supplier.get()).shutdown();
    }
}

