/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.adapter;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.NoSla;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.client.dto.ContractDto;
import com.mulesoft.mule.runtime.gw.client.dto.LimitDto;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ContractBuilder
implements Builder<Contract> {
    private ContractDto dto;

    public ContractBuilder from(ContractDto dto) {
        this.dto = dto;
        return this;
    }

    public Contract build() {
        Contract contract;
        Client client = Client.builder().withId(this.clientId()).withSecret(this.clientSecret()).withName(this.clientName()).build();
        if (!this.nullTier() && !this.nullLimits()) {
            Integer slaId = this.slaId();
            List<LimitDto> limits = this.dto.getTier().getLimits();
            List tiers = limits.stream().map(limit -> new SingleTier(Integer.valueOf(limit.getMaximumRequests()), Long.valueOf(limit.getTimePeriodInMilliseconds()))).collect(Collectors.toList());
            contract = Contract.builder().withClient(client).withSla(new Sla(slaId, tiers)).build();
        } else {
            contract = Contract.builder().withClient(client).withSla((Sla)new NoSla()).build();
        }
        return contract;
    }

    private boolean nullLimits() {
        return this.dto.getTier().getLimits() == null;
    }

    private boolean nullTier() {
        return this.dto.getTier() == null;
    }

    private Integer slaId() {
        Integer slaId = this.dto.getTier().getId();
        Objects.requireNonNull(slaId, "Cannot create a Contract without an SLA ID");
        return slaId;
    }

    private String clientSecret() {
        String clientSecret = this.dto.getApp().getClientSecret();
        Objects.requireNonNull(clientSecret, "Cannot create a Contract without client secret");
        return clientSecret;
    }

    private String clientId() {
        String clientId = this.dto.getApp().getClientId();
        Objects.requireNonNull(clientId, "Cannot create a Contract without client id");
        return clientId;
    }

    private String clientName() {
        String clientName = this.dto.getApp().getName();
        Objects.requireNonNull(clientName, "Cannot create a Contract without client name");
        return clientName;
    }
}

