/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.retry.runnable;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.retry.session.ErrorSessionMetadata;
import com.mulesoft.anypoint.retry.session.RetryFailedSessionMetadata;
import com.mulesoft.anypoint.retry.session.RetrySuccessfulSessionMetadata;

public class RetrierRunnable<T>
extends BackoffRunnable {
    private final T key;
    private final Runnable innerRunnable;

    public RetrierRunnable(T key, Runnable runnable, BackoffConfiguration configuration, BackoffBarrier barrier) {
        super(configuration, barrier);
        this.key = key;
        this.innerRunnable = runnable;
    }

    @Override
    protected SessionMetadata execute() {
        try {
            this.innerRunnable.run();
            return new RetrySuccessfulSessionMetadata();
        }
        catch (Exception e) {
            return new RetryFailedSessionMetadata();
        }
        catch (Throwable t) {
            return new ErrorSessionMetadata();
        }
    }

    public T key() {
        return this.key;
    }

    public Runnable inner() {
        return this.innerRunnable;
    }

    @Override
    public String toString() {
        return "RetrierRunnable{key=" + String.valueOf(this.key) + ", innerRunnable=" + String.valueOf(this.innerRunnable) + "}";
    }
}

