/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class State {
    protected static final Logger LOGGER = LoggerFactory.getLogger(State.class);
    protected BackoffConfiguration configuration;
    protected BackoffBarrier backoffBarrier;
    protected Optional<Runnable> unstableClosure;
    protected Optional<Runnable> stableClosure;
    protected Optional<Runnable> errorClosure;

    public State(BackoffConfiguration configuration, BackoffBarrier backoffBarrier) {
        this.configuration = configuration;
        this.backoffBarrier = backoffBarrier;
        this.resetClosures();
    }

    public abstract State next(SessionMetadata var1);

    public abstract Period delay();

    public State ifUnstable(Runnable closure) {
        this.unstableClosure = Optional.of(closure);
        return this;
    }

    public State ifError(Runnable closure) {
        this.errorClosure = Optional.of(closure);
        return this;
    }

    public State otherwise(Runnable closure) {
        this.stableClosure = Optional.of(closure);
        return this;
    }

    public abstract State go();

    public abstract State log();

    protected State resetClosures() {
        this.unstableClosure = Optional.empty();
        this.stableClosure = Optional.empty();
        return this;
    }
}

