/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.BackingOff;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class Error
extends State {
    protected int step;

    public Error(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
        super(configuration, backoffBarrier);
        this.step = step;
    }

    @Override
    public State next(SessionMetadata sessionMetadata) {
        if (this.backoffBarrier.gotError(sessionMetadata) || this.configuration.isFastRecovery()) {
            return new Error(this.configuration, this.backoffBarrier, this.step + 1);
        }
        return this.backoffBarrier.shouldBackoff(sessionMetadata, this.configuration) ? new BackingOff(this.configuration, this.backoffBarrier, this.step + 1) : new Stable(this.configuration, this.backoffBarrier);
    }

    @Override
    public Period delay() {
        return Period.seconds((int)this.configuration.backoff().apply(this.step));
    }

    @Override
    public State go() {
        this.errorClosure.ifPresent(Runnable::run);
        return this.resetClosures();
    }

    @Override
    public State log() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Error;
    }

    public String toString() {
        return "Error{}";
    }
}

