/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.BackingOn;
import com.mulesoft.anypoint.backoff.state.Error;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.anypoint.backoff.state.Unstable;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class BackingOff
extends Unstable {
    public BackingOff(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
        super(configuration, backoffBarrier, step);
    }

    @Override
    public State next(SessionMetadata sessionMetadata) {
        if (this.backoffBarrier.gotError(sessionMetadata)) {
            return new Error(this.configuration, this.backoffBarrier, this.step + 1);
        }
        if (this.backoffBarrier.shouldBackoff(sessionMetadata, this.configuration)) {
            return new BackingOff(this.configuration, this.backoffBarrier, Math.min(this.step + 1, this.configuration.backoffSteps()));
        }
        if (this.step == 1 || this.configuration.isFastRecovery()) {
            return new Stable(this.configuration, this.backoffBarrier);
        }
        return new BackingOn(this.configuration, this.backoffBarrier, Math.min(this.step - 1, this.configuration.backonSteps()));
    }

    @Override
    public Period delay() {
        return Period.seconds((int)this.configuration.backoff().apply(this.step));
    }

    @Override
    protected String name() {
        return "backoff";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackingOff)) {
            return false;
        }
        BackingOff that = (BackingOff)o;
        return this.step == that.step;
    }

    public int hashCode() {
        return this.step;
    }

    public String toString() {
        return "BackingOff{step=" + this.step + '}';
    }
}

