/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.function;

import java.util.function.Function;

public class BoundedExponentialFunction
implements Function<Integer, Double> {
    private final double base;
    private final double multiplier;
    private final int minExponent;
    private final int maxExponent;
    private final Function<Double, Double> dispersant;

    public BoundedExponentialFunction(double base, int minExponent, int maxExponent, double multiplier) {
        this(base, minExponent, maxExponent, multiplier, Function.identity());
    }

    public BoundedExponentialFunction(double base, int minExponent, int maxExponent, double multiplier, Function<Double, Double> dispersant) {
        this.base = base;
        this.multiplier = multiplier;
        this.minExponent = minExponent;
        this.maxExponent = maxExponent;
        this.dispersant = dispersant;
    }

    @Override
    public Double apply(Integer x) {
        int exponent = Math.max(Math.min(x, this.maxExponent), this.minExponent);
        return this.dispersant.apply(this.multiplier * Math.pow(this.base, exponent));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundedExponentialFunction that = (BoundedExponentialFunction)o;
        if (Double.compare(that.base, this.base) != 0) {
            return false;
        }
        if (Double.compare(that.multiplier, this.multiplier) != 0) {
            return false;
        }
        if (this.minExponent != that.minExponent) {
            return false;
        }
        if (this.maxExponent != that.maxExponent) {
            return false;
        }
        return this.dispersant.equals(that.dispersant);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.base);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.minExponent;
        result = 31 * result + this.maxExponent;
        result = 31 * result + this.dispersant.hashCode();
        return result;
    }

    public String toString() {
        return "BoundedExponentialFunction{base=" + this.base + ", multiplier=" + this.multiplier + ", minExponent=" + this.minExponent + ", maxExponent=" + this.maxExponent + ", dispersant=" + this.dispersant + '}';
    }
}

