/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.expirable.os;

import com.mulesoft.mule.runtime.gw.api.expirable.Expirable;
import com.mulesoft.mule.runtime.gw.api.expirable.ExpirableObjectFactory;
import com.mulesoft.mule.runtime.gw.api.expirable.exception.ExpirableObjectMessage;
import com.mulesoft.mule.runtime.gw.api.functional.StreamsInMaps;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public class ExpirableObjectStore<T extends Serializable>
implements ObjectStore<T> {
    private final ObjectStore<Expirable<T>> innerOS;
    private final ExpirableObjectFactory<T> expirableObjectFactory;

    public ExpirableObjectStore(ObjectStore<Expirable<T>> innerOS, ExpirableObjectFactory<T> expirableObjectFactory) {
        this.innerOS = innerOS;
        this.expirableObjectFactory = expirableObjectFactory;
    }

    public boolean contains(String key) throws ObjectStoreException {
        return this.innerOS.contains(key) && !((Expirable)this.innerOS.retrieve(key)).isExpired();
    }

    public void store(String key, T value) throws ObjectStoreException {
        if (this.innerOS.contains(key)) {
            this.innerOS.remove(key);
        }
        this.innerOS.store(key, this.expirableObjectFactory.create(value));
    }

    public T retrieve(String key) throws ObjectStoreException {
        Expirable retrievedValue = (Expirable)this.innerOS.retrieve(key);
        if (retrievedValue.isExpired()) {
            this.innerOS.remove(key);
            throw this.expiredEntryException((Serializable)((Object)key));
        }
        return (T)((Serializable)retrievedValue.value());
    }

    public T remove(String key) throws ObjectStoreException {
        Expirable removedExpirable = (Expirable)this.innerOS.remove(key);
        if (removedExpirable.isExpired()) {
            throw this.expiredEntryException((Serializable)((Object)key));
        }
        return (T)((Serializable)removedExpirable.value());
    }

    public boolean isPersistent() {
        return this.innerOS.isPersistent();
    }

    public void clear() throws ObjectStoreException {
        this.innerOS.clear();
    }

    public void open() throws ObjectStoreException {
        this.innerOS.open();
    }

    public void close() throws ObjectStoreException {
        this.innerOS.close();
    }

    public List<String> allKeys() throws ObjectStoreException {
        return this.innerOS.allKeys();
    }

    public Map<String, T> retrieveAll() throws ObjectStoreException {
        HashSet<String> keysToRemove = new HashSet<String>();
        Map nonExpiredEntries = this.innerOS.retrieveAll().entrySet().stream().filter(this.expiredEntries(keysToRemove)).collect(StreamsInMaps.mapWithValues(e -> (Serializable)((Expirable)e.getValue()).value()));
        this.cleanUpInnerOs(keysToRemove);
        return nonExpiredEntries;
    }

    private void cleanUpInnerOs(Set<String> keysToRemove) throws ObjectStoreException {
        for (String key : keysToRemove) {
            this.innerOS.remove(key);
        }
    }

    private Predicate<Map.Entry<String, Expirable<T>>> expiredEntries(Set<String> keysToRemove) {
        return e -> {
            boolean expiredEntry = ((Expirable)e.getValue()).isExpired();
            if (expiredEntry) {
                keysToRemove.add((String)e.getKey());
            }
            return !expiredEntry;
        };
    }

    protected ObjectDoesNotExistException expiredEntryException(Serializable key) {
        return new ObjectDoesNotExistException((Throwable)new ExpirableObjectMessage(String.format("Value for %s has been found but is expired.", key)));
    }
}

