/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import com.mulesoft.mule.runtime.gw.api.config.GatewaySecurityConfiguration;
import com.mulesoft.mule.runtime.gw.internal.encryption.DefaultRuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.internal.encryption.GatewayEncrypterBuilder;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.internal.encryption.UnsecuredRuntimeEncrypter;
import org.mule.encryption.Encrypter;

public class RuntimeEncrypterFactory {
    public static RuntimeEncrypter createDefaultRuntimeEncrypter() {
        GatewaySecurityConfiguration config = new GatewaySecurityConfiguration();
        return config.isEncryptionEnabled() ? RuntimeEncrypterFactory.createRuntimeEncrypter(config.getEncryptionKey()) : new UnsecuredRuntimeEncrypter();
    }

    public static RuntimeEncrypter createRuntimeEncrypter(String encryptionKey) {
        return new DefaultRuntimeEncrypter(RuntimeEncrypterFactory.buildDefaultEncrypter(encryptionKey));
    }

    private static Encrypter buildDefaultEncrypter(String key) {
        return new GatewayEncrypterBuilder().key(key).algorithm("AES").transformation("AES/CBC/PKCS5Padding").build();
    }
}

