/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public class GatewaySecurityConfiguration
extends RuntimeConfiguration {
    private static final String ENCRYPTION_KEY = "anypoint.platform.encryption_key";
    private static final String POLICY_ENCRYPTION_MODE = "anypoint.platform.policy_encryption_mode";
    private static final EncryptionMode POLICY_ENCRYPTION_MODE_DEFAULT = EncryptionMode.SENSITIVE_ONLY;
    private static final String HASH_CLIENTS = "anypoint.platform.hash_clients";
    private static final String HASH_CLIENTS_DEFAULT = "true";
    private static final String HASH_CLIENTS_ALGORITHM = "anypoint.platform.hash_clients.algorithm";
    private static final String HASH_CLIENTS_ALGORITHM_DEFAULT = "SHA-256";

    public String getEncryptionKey() {
        return StringUtils.trimToNull((String)System.getProperty(ENCRYPTION_KEY));
    }

    public boolean isEncryptionEnabled() {
        return this.getEncryptionKey() != null;
    }

    public boolean isSensitiveOnlyEncryption() {
        return this.parsePropertyValue().equals((Object)EncryptionMode.SENSITIVE_ONLY);
    }

    private EncryptionMode parsePropertyValue() {
        String modeInput = StringUtils.trimToNull((String)System.getProperty(POLICY_ENCRYPTION_MODE, POLICY_ENCRYPTION_MODE_DEFAULT.name()));
        try {
            return EncryptionMode.valueOf(modeInput.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("{} is not a valid Policy Encryption configuration mode. {} mode will be used", (Object)modeInput, (Object)POLICY_ENCRYPTION_MODE_DEFAULT);
            return POLICY_ENCRYPTION_MODE_DEFAULT;
        }
    }

    public void clearEncryptionKey() {
        System.clearProperty(ENCRYPTION_KEY);
    }

    public boolean hashClients() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(HASH_CLIENTS, HASH_CLIENTS_DEFAULT)));
    }

    public String hashAlgorithm() {
        String algorithm = StringUtils.trimToNull((String)System.getProperty(HASH_CLIENTS_ALGORITHM, HASH_CLIENTS_ALGORITHM_DEFAULT)).toUpperCase();
        try {
            MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn("{} is not a valid Hashing algorithm. {} algorithm will be used.", (Object)algorithm, (Object)HASH_CLIENTS_ALGORITHM_DEFAULT);
            return HASH_CLIENTS_ALGORITHM_DEFAULT;
        }
        return algorithm;
    }

    public static enum EncryptionMode {
        FULL,
        SENSITIVE_ONLY;

    }
}

