/*
 * Decompiled with CFR 0.152.
 */
package com.multilevelview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.multilevelview.MultiLevelAdapter;
import com.multilevelview.OnRecyclerItemClickListener;
import com.multilevelview.animators.DefaultItemAnimator;
import com.multilevelview.models.RecyclerViewItem;
import java.util.List;

public class MultiLevelRecyclerView
extends RecyclerView
implements OnRecyclerItemClickListener {
    public static final String TAG = MultiLevelRecyclerView.class.getName();
    Context mContext;
    private boolean isExpanded = false;
    private boolean accordion = false;
    private int prevClickedPosition = -1;
    private int numberOfItemsAdded = 0;
    private MultiLevelAdapter mMultiLevelAdapter;
    private boolean isToggleItemOnClick = true;
    private RecyclerItemClickListener recyclerItemClickListener;
    private OnRecyclerItemClickListener onRecyclerItemClickListener;

    public void setAccordion(boolean accordion) {
        this.accordion = accordion;
    }

    public void setOnItemClick(OnRecyclerItemClickListener onItemClick) {
        this.onRecyclerItemClickListener = onItemClick;
    }

    public void setToggleItemOnClick(boolean toggleItemOnClick) {
        this.isToggleItemOnClick = toggleItemOnClick;
    }

    public MultiLevelRecyclerView(Context context) {
        super(context);
        this.mContext = context;
        this.setUp(context);
    }

    public MultiLevelRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setUp(context);
    }

    public MultiLevelRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setUp(context);
    }

    private void setUp(Context context) {
        this.recyclerItemClickListener = new RecyclerItemClickListener(context);
        this.recyclerItemClickListener.setOnItemClick(this);
        this.addOnItemTouchListener(this.recyclerItemClickListener);
        this.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public void removeItemClickListeners() {
        if (this.recyclerItemClickListener != null) {
            this.removeOnItemTouchListener(this.recyclerItemClickListener);
        }
    }

    public void setItemAnimator(RecyclerView.ItemAnimator animator) {
        super.setItemAnimator(animator);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (!(adapter instanceof MultiLevelAdapter)) {
            throw new IllegalStateException("Please Set Adapter Of the MultiLevelAdapter Class.");
        }
        this.mMultiLevelAdapter = (MultiLevelAdapter)adapter;
        super.setAdapter(adapter);
    }

    public void removeAllChildren(List<RecyclerViewItem> list) {
        for (RecyclerViewItem i : list) {
            if (!i.isExpanded()) continue;
            i.setExpanded(false);
            this.removeAllChildren(i.getChildren());
            this.removePrevItems(this.mMultiLevelAdapter.getRecyclerViewItemList(), i.getPosition(), i.getChildren().size());
        }
    }

    private int getExpandedPosition(int level) {
        List<RecyclerViewItem> adapterList = this.mMultiLevelAdapter.getRecyclerViewItemList();
        for (RecyclerViewItem i : adapterList) {
            if (level != i.getLevel() || !i.isExpanded()) continue;
            return adapterList.indexOf(i);
        }
        return -1;
    }

    private int getItemsToBeRemoved(int level) {
        List<RecyclerViewItem> adapterList = this.mMultiLevelAdapter.getRecyclerViewItemList();
        int itemsToRemove = 0;
        for (RecyclerViewItem i : adapterList) {
            if (level >= i.getLevel()) continue;
            ++itemsToRemove;
        }
        return itemsToRemove;
    }

    public void openTill(int ... positions) {
        if (this.mMultiLevelAdapter == null) {
            return;
        }
        List<RecyclerViewItem> adapterList = this.mMultiLevelAdapter.getRecyclerViewItemList();
        if (adapterList == null || positions.length <= 0) {
            return;
        }
        int posToAdd = 0;
        int insidePosStart = -1;
        int insidePosEnd = adapterList.size();
        for (int position : positions) {
            if ((posToAdd += position) <= insidePosStart || posToAdd >= insidePosEnd) continue;
            this.addItems(adapterList.get(posToAdd), adapterList, posToAdd);
            insidePosStart = posToAdd;
            if (adapterList.get(posToAdd).getChildren() == null) break;
            insidePosEnd = adapterList.get(posToAdd).getChildren().size();
            ++posToAdd;
        }
    }

    public void toggleItemsGroup(int position) {
        if (position == -1) {
            return;
        }
        List<RecyclerViewItem> adapterList = this.mMultiLevelAdapter.getRecyclerViewItemList();
        RecyclerViewItem clickedItem = adapterList.get(position);
        if (this.accordion) {
            if (clickedItem.isExpanded()) {
                clickedItem.setExpanded(false);
                this.removeAllChildren(clickedItem.getChildren());
                this.removePrevItems(adapterList, position, clickedItem.getChildren().size());
                this.prevClickedPosition = -1;
                this.numberOfItemsAdded = 0;
            } else {
                int i = this.getExpandedPosition(clickedItem.getLevel());
                int itemsToRemove = this.getItemsToBeRemoved(clickedItem.getLevel());
                if (i != -1) {
                    this.removePrevItems(adapterList, i, itemsToRemove);
                    adapterList.get(i).setExpanded(false);
                    if (clickedItem.getPosition() > adapterList.get(i).getPosition()) {
                        this.addItems(clickedItem, adapterList, position - itemsToRemove);
                    } else {
                        this.addItems(clickedItem, adapterList, position);
                    }
                } else {
                    this.addItems(clickedItem, adapterList, position);
                }
            }
        } else if (clickedItem.isExpanded()) {
            clickedItem.setExpanded(false);
            this.removeAllChildren(clickedItem.getChildren());
            this.removePrevItems(adapterList, position, clickedItem.getChildren().size());
            this.prevClickedPosition = -1;
            this.numberOfItemsAdded = 0;
        } else if (clickedItem.isExpanded()) {
            this.removePrevItems(adapterList, this.prevClickedPosition, this.numberOfItemsAdded);
            this.addItems(clickedItem, adapterList, clickedItem.getPosition());
        } else {
            this.addItems(clickedItem, adapterList, position);
        }
    }

    @Override
    public void onItemClick(View view, RecyclerViewItem clickedItem, int position) {
        if (this.isToggleItemOnClick) {
            this.toggleItemsGroup(position);
        }
        if (this.onRecyclerItemClickListener != null) {
            this.onRecyclerItemClickListener.onItemClick(view, clickedItem, position);
        }
    }

    private void removePrevItems(List<RecyclerViewItem> tempList, int position, int numberOfItemsAdded) {
        for (int i = 0; i < numberOfItemsAdded; ++i) {
            tempList.remove(position + 1);
        }
        this.isExpanded = false;
        this.mMultiLevelAdapter.setRecyclerViewItemList(tempList);
        this.mMultiLevelAdapter.notifyItemRangeRemoved(position + 1, numberOfItemsAdded);
        this.refreshPosition();
    }

    public void refreshPosition() {
        int position = 0;
        for (RecyclerViewItem i : this.mMultiLevelAdapter.getRecyclerViewItemList()) {
            i.setPosition(position++);
        }
    }

    public RecyclerViewItem getParentOfItem(RecyclerViewItem item) {
        try {
            int l;
            List<RecyclerViewItem> list = this.mMultiLevelAdapter.getRecyclerViewItemList();
            if (item.getLevel() == 1) {
                return list.get(item.getPosition());
            }
            int i = item.getPosition();
            while ((l = list.get(i).getLevel()) != item.getLevel() - 1) {
                --i;
            }
            return list.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private void addItems(RecyclerViewItem clickedItem, List<RecyclerViewItem> tempList, int position) {
        if (clickedItem.hasChildren()) {
            this.isExpanded = true;
            this.prevClickedPosition = position;
            tempList.addAll(position + 1, clickedItem.getChildren());
            clickedItem.setExpanded(true);
            this.numberOfItemsAdded = clickedItem.getChildren().size();
            this.mMultiLevelAdapter.setRecyclerViewItemList(tempList);
            this.mMultiLevelAdapter.notifyItemRangeInserted(position + 1, clickedItem.getChildren().size());
            this.smoothScrollToPosition(position);
            this.refreshPosition();
        }
    }

    private final class RecyclerItemClickListener
    implements RecyclerView.OnItemTouchListener {
        private GestureDetector mGestureDetector;
        private OnRecyclerItemClickListener onItemClick;

        void setOnItemClick(OnRecyclerItemClickListener onItemClick) {
            this.onItemClick = onItemClick;
        }

        RecyclerItemClickListener(Context context) {
            this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onSingleTapUp(MotionEvent e) {
                    return true;
                }
            });
        }

        public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
            View childView = view.findChildViewUnder(e.getX(), e.getY());
            if (childView != null && this.mGestureDetector.onTouchEvent(e)) {
                childView.performClick();
                int position = view.getChildAdapterPosition(childView);
                Log.e((String)TAG, (String)(position + " Clicked On RecyclerView"));
                if (this.onItemClick != null) {
                    this.onItemClick.onItemClick(childView, MultiLevelRecyclerView.this.mMultiLevelAdapter.getRecyclerViewItemList().get(position), position);
                }
                return MultiLevelRecyclerView.this.isToggleItemOnClick;
            }
            return false;
        }

        public void onTouchEvent(RecyclerView view, MotionEvent motionEvent) {
        }

        public void onRequestDisallowInterceptTouchEvent(boolean arg0) {
        }
    }
}

