/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.web;

import com.mtvnet.boxspring.path.ChildPathedBeanFactoryPostProcessor;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;

public class ServletContextAwareChildPostProcessor
extends ChildPathedBeanFactoryPostProcessor {
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    private BeanPostProcessor beanPostProcessor;

    public ServletContextAwareChildPostProcessor(ServletContext servletContext, ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
        this.beanPostProcessor = new ServletContextAwareProcessor();
    }

    protected Object postProcessChildBeanFactory(PathedBeanFactory beanFactory, String beanName) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)beanFactory).addBeanPostProcessor(this.beanPostProcessor);
        }
        return beanFactory;
    }

    private class ServletContextAwareProcessor
    implements BeanPostProcessor {
        private ServletContextAwareProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (ServletContextAwareChildPostProcessor.this.servletContext != null && bean instanceof ServletContextAware) {
                ((ServletContextAware)bean).setServletContext(ServletContextAwareChildPostProcessor.this.servletContext);
            }
            if (ServletContextAwareChildPostProcessor.this.servletConfig != null && bean instanceof ServletConfigAware) {
                ((ServletConfigAware)bean).setServletConfig(ServletContextAwareChildPostProcessor.this.servletConfig);
            }
            return bean;
        }
    }
}

