/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionHolder handlerMappingHolder = this.registerDefaultAnnotationHandlerMapping(element, source, parserContext);
        BeanDefinitionHolder handlerAdapterHolder = this.registerAnnotationMethodHandlerAdapter(element, source, parserContext);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(handlerMappingHolder));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(handlerAdapterHolder));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private BeanDefinitionHolder registerDefaultAnnotationHandlerMapping(Element element, Object source, ParserContext context) {
        BeanDefinitionBuilder builder = this.createBeanBuilder(DefaultAnnotationHandlerMapping.class, source);
        builder.addPropertyValue("order", (Object)0);
        return this.registerBeanDefinition((BeanDefinition)builder.getBeanDefinition(), context);
    }

    private BeanDefinitionHolder registerAnnotationMethodHandlerAdapter(Element element, Object source, ParserContext context) {
        BeanDefinitionBuilder builder = this.createBeanBuilder(AnnotationMethodHandlerAdapter.class, source);
        builder.addPropertyValue("webBindingInitializer", (Object)this.createWebBindingInitializer(element, source, context));
        return this.registerBeanDefinition((BeanDefinition)builder.getBeanDefinition(), context);
    }

    private BeanDefinition createWebBindingInitializer(Element element, Object source, ParserContext context) {
        BeanDefinitionBuilder builder = this.createBeanBuilder(ConfigurableWebBindingInitializer.class, source);
        this.addConversionService(builder, element, source, context);
        this.addValidator(builder, element, source, context);
        return builder.getBeanDefinition();
    }

    private void addConversionService(BeanDefinitionBuilder builder, Element element, Object source, ParserContext context) {
        if (element.hasAttribute("conversion-service")) {
            builder.addPropertyReference("conversionService", element.getAttribute("conversion-service"));
        } else {
            builder.addPropertyValue("conversionService", (Object)this.createDefaultConversionService(element, source, context));
        }
    }

    private void addValidator(BeanDefinitionBuilder builder, Element element, Object source, ParserContext context) {
        if (element.hasAttribute("validator")) {
            builder.addPropertyReference("validator", element.getAttribute("validator"));
        } else if (ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader())) {
            builder.addPropertyValue("validator", (Object)this.createDefaultValidator(element, source, context));
        }
    }

    private BeanDefinition createDefaultConversionService(Element element, Object source, ParserContext context) {
        BeanDefinitionBuilder builder = this.createBeanBuilder(FormattingConversionServiceFactoryBean.class, source);
        return builder.getBeanDefinition();
    }

    private BeanDefinition createDefaultValidator(Element element, Object source, ParserContext context) {
        BeanDefinitionBuilder builder = this.createBeanBuilder(LocalValidatorFactoryBean.class, source);
        return builder.getBeanDefinition();
    }

    private BeanDefinitionHolder registerBeanDefinition(BeanDefinition definition, ParserContext context) {
        String beanName = context.getReaderContext().generateBeanName(definition);
        context.getRegistry().registerBeanDefinition(beanName, definition);
        return new BeanDefinitionHolder(definition, beanName);
    }

    private BeanDefinitionBuilder createBeanBuilder(Class<?> clazz, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        builder.getRawBeanDefinition().setSource(source);
        return builder;
    }
}

