/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.web.extender.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.springframework.util.StringUtils;

public class ResourceFindingHttpContext
implements HttpContext {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private Bundle bundle;
    private MimetypesFileTypeMap mimeTypesMap;
    private static final Log logger = LogFactory.getLog(ResourceFindingHttpContext.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public ResourceFindingHttpContext(Bundle bundle) {
        String parsedTypes;
        this.bundle = bundle;
        InputStream is = this.getClass().getResourceAsStream("/META-INF/mime.types");
        this.mimeTypesMap = new MimetypesFileTypeMap(is);
        URL additionalTypes = bundle.getResource("/META-INF/mime.types");
        if (additionalTypes != null && StringUtils.hasText((String)(parsedTypes = this.toString(additionalTypes)))) {
            this.mimeTypesMap.addMimeTypes(parsedTypes);
        }
    }

    public String getMimeType(String name) {
        String mimeType = this.mimeTypesMap.getContentType(name);
        if (DEFAULT_CONTENT_TYPE.equals(mimeType) && name.contains(";")) {
            name = name.substring(0, name.indexOf(";"));
            mimeType = this.mimeTypesMap.getContentType(name);
        }
        if (DEFAULT_CONTENT_TYPE.equals(mimeType) && name.endsWith("/")) {
            mimeType = this.mimeTypesMap.getContentType(name.substring(0, name.length() - 1));
        }
        return mimeType;
    }

    public URL getResource(String name) {
        URL res;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((res = this.bundle.getResource(name)) == null && name.contains(";")) {
            name = name.substring(0, name.indexOf(";"));
            res = this.bundle.getResource(name);
        }
        if (res == null && name.endsWith("/")) {
            res = this.bundle.getResource(name.substring(0, name.length() - 1));
        }
        return res;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(URL additionalTypes) {
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(additionalTypes.openStream());
            StringWriter out = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                out.write(buffer, 0, n);
            }
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            logger.error((Object)("Unable to load custom mime types from " + additionalTypes), (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

